package cn.com.duiba.youqian.center.api.exception;

import org.apache.commons.lang3.StringUtils;

import java.util.Collection;
import java.util.Map;

/**
 * @author tengtuox
 * @date 2019/10/10
 * @description: 参数校验
 * 对于前端发送过来的请求，尽量先使用java validation的注解进行校验，
 * 如果java validation搞不定，则使用ParamChecker进行手动校验
 */
public abstract class ParamChecker {

    protected static void throwException(String message) {
        throw new ParamException(message);
    }

    public static void checkNotNull(Object o, String message) {
        if (o != null) {
            return;
        }
        throwException(message);
    }

    public static void checkIsTrue(boolean expression, String message) {
        if (expression) {
            return;
        }
        throwException(message);
    }

    public static void checkNotBlank(String test, String message) {
        if (StringUtils.isNotBlank(test)) {
            return;
        }
        throwException(message);
    }

    public static void checkGtZero(Number number, String message) {
        if (number != null) {
            if (number instanceof Integer && (Integer) number > 0) {
                return;
            }
            if (number instanceof Long && (Long) number > 0L) {
                return;
            }
            if (number instanceof Float && (Float) number > 0F) {
                return;
            }
            if (number instanceof Double && (Double) number > 0D) {
                return;
            }
        }
        throwException(message);
    }

    public static void checkNotEmpty(Collection collection, String message) {
        if (collection != null && collection.size() > 0) {
            return;
        }
        throwException(message);
    }

    public static void checkNotEmpty(Map map, String message) {
        if (map != null && map.size() > 0) {
            return;
        }
        throwException(message);
    }
}
