package cn.com.duiba.youqian.center.api.exception;

import lombok.Getter;

/**
 * @author tengtuox
 * @date 2019/12/27
 * @description: 错误码
 */
@Getter
public enum StandardCode implements ErrorCode {

    SUCCESS(0, "success"),
    UNKNOWN_ERROR(500, "系统繁忙"),
    THIRD_ERROR(900, "第三方异常"),

    PARAM_ERROR(1000000, "参数错误"),
    PERMISSION_DENY(999999, "无权限"),

    // User错误10开头
    USER_NOT_EXISTS(100001, "用户不存在"),
    PASSWORD_ERROR(100002, "账号或密码错误"),
    USER_ALREADY_EXISTS(100003, "用户已存在"),
    USER_NOT_AUTH(100004, "用户未认证"),
    ADDRESS_NOT_EXISTS(100005, "地址不存在"),
    USER_ROLE_EXISTS(100006, "用户权限不能为空"),
    BUY_USER_NOT_EXISTS(100007, "买家手机号不能为空"),
    BUY_USER_NAME_NOT_EXISTS(100008, "买家姓名不能为空"),

    // Merchant 11开头
    MERCHANT_NOT_EXISTS(110001, "商户不存在"),
    EMPLOYEE_ALREADY_HAS_MERCHANT(110002, "员工已经加入了一个商户, 不能重复加入"),
    EMPLOYEE_NOT_EXISTS(110003, "员工不存在"),
    MERCHANT_ALREADY_EXISTS(110004, "商户名称已存在"),
    SIGN_ENTITY_NOT_EXISTS(110005, "签约主体不存在"),
    ORG_ALREADY_EXISTS(110006, "组织已存在"),
    MERCHANT_PERMISSION_DENY(110007, "你没有该商户的权限"),
    MERCHANT_TEMPLATE_EXISTS(110008, "模板已添加"),
    MERCHANT_TEMPLATE_NOT_EXISTS(110009, "模板不存在"),
    GOODS_SPEC_EXISTS(110010, "商品已存在"),
    GOODS_SPEC_NOT_EXISTS(110011, "商品不存在"),
    SIGN_ENTITY_EXISTS(110012, "签约主体已存在"),
    ENT_4_NOT_MATCH(110013, "企业四要素不通过"),
    ENT_AUTH_NOT_EXISTS(110014, "企业未提交基本信息"),
    ENT_LEGAL_NOT_MATCH(110015, "企业和法人不匹配"),
    LEGAL_3_NOT_MATCH(110016, "法人三要素不匹配"),
    ENT_BELONG_OTHERS(110017, "当前企业已经属于其他商户"),

    // Manage 12开头
    MANAGE_USER_NOT_EXISTS(120001, "用户不存在"),
    MANAGE_PASSWORD_ERROR(120002, "账号或密码错误"),
    MANAGE_USER_ALREADY_EXISTS(120003, "用户已存在"),

    // Order 13开头
    ORDER_NOT_EXISTS(130001, "订单不存在"),
    ORDER_UPDATE_FAIL(130002, "订单更新失败"),
    ORDER_SIGN_NOT_UPDATE(130003, "签署订单不允许修改"),
    ORDER_ALREADY_SIGN(130004, "订单已签署"),
    ORDER_BUYER_INFO_NOT_PERSONAL(130005, "订单买家信息必须为本人"),
    ORDER_SHELL_INFO_NOT_PERSONAL(130006, "订单卖家信息必须为签约主体"),
    ORDER_NO_LOOK_POWER(130007, "没有查看当前订单的权限"),
    ORDER_STATUS_ERROR(130008, "操作有误"),
    ORDER_NAME_NOT_SAME(130009,"订单的买家姓名不能与卖家姓名一样"),

    // Contract 14开头
    TEMPLATE_NOT_EXISTS(140001, "合同模板不存在"),
    TEMPLATE_ALREADY_EXISTS(140002, "模板已存在"),

    //Img 15开头
    IMG_NOT_UPLOAD(150001, "请上传照片"),
    IMG_CONVERSION_FAIL(150002, "图片转换有误"),
    IMG_REPEAT_UPLOAD(150003, "信息认证中，请稍后再试"),
    IMG_REPEAT_UPLOAD_FAIL(150003, "信息认证失败"),

    //Sms 16开头
    SMS_NOT_SEND(160001,"短信未发送"),
    SMS_CHECK_ERROR(160002,"短信校验有误"),

    //短信 16开头
    SEND_SMS_ERROR(160001, "发送短信验证码错误"),
    SMS_MOT_MATCH(160002, "短信验证码错误"),


  ;

    private Integer code;

    private String strCode;

    private String description;

    StandardCode(Integer code, String description) {
        this.code = code;
        this.strCode = String.valueOf(code);
        this.description = description;
    }

    @Override
    public String getDesc() {
        return description;
    }
}
