package cn.com.duiba.youqian.center.api.request.contract;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/2/4
 * @description
 */
@Data
public class AddTemplateFieldRequest implements Serializable {
    private static final long serialVersionUID = 7842753798907226556L;

    @NotBlank
    @ApiModelProperty(value = "字段类目", required = true)
    private String fieldCategory;

    @NotBlank
    @ApiModelProperty(value = "字段名称", required = true)
    private String fieldName;

    @Min(1)
    @NotNull
    @ApiModelProperty(value = "字段类型，1-文本/2-日期/3-选择框/4-开关", required = true)
    private Byte fieldType;

    @Min(1)
    @NotNull
    @ApiModelProperty(value = "是否必填，0-非必填，1-必填", required = true)
    private Byte require;

    @ApiModelProperty(value = "提示信息")
    private String placeholder;

    @ApiModelProperty(value = "内容，多个用逗号分隔（如选择框）")
    private String preValue;

    @ApiModelProperty(value = "默认值")
    private String defValue;
}
