package cn.com.duiba.youqian.center.api.request.contract;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/2/4
 * @description
 */
@Data
public class UpGradeTemplateRequest implements Serializable {
    private static final long serialVersionUID = 198043074232015955L;

    @Min(1)
    @NotNull
    @ApiModelProperty(value = "原模板ID", required = true)
    private Long templateId;

    @NotBlank
    @ApiModelProperty(value = "模板名称", required = true)
    private String templateName;

    @ApiModelProperty(value = "模板简介")
    private String description;

    @NotBlank
    @ApiModelProperty(value = "版本号", required = true)
    private String version;

    @ApiModelProperty(value = "模板状态，0-正常，1-下线，2-过期（已有更新版本）")
    private Byte status;

    @NotBlank
    @ApiModelProperty(value = "内容", required = true)
    private String content;

    @Valid
    @NotNull
    @ApiModelProperty(value = "模板字段", required = true)
    private List<AddTemplateFieldRequest> fieldList;

}
