package cn.com.duiba.youqian.center.api.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import lombok.Data;

/**
 * `order_main`
 */
@Data
public class Order implements Serializable {
    @ApiModelProperty("订单ID")
    private Long orderId;

    @ApiModelProperty("商户ID")
    private Long merchantId;

    @ApiModelProperty("组织ID")
    private Long orgId;

    @ApiModelProperty("订单创建人")
    private Long createUserId;

    @ApiModelProperty("开单人姓名")
    private String createUserName;

    @ApiModelProperty("开单账号")
    private String createAccount;

    @ApiModelProperty("买家UserId")
    private Long buyerUserId;

    @ApiModelProperty("买家手机号")
    private String buyerMobile;

    @ApiModelProperty("买家经办人名称")
    private String buyerName;

    @ApiModelProperty("买家主体ID")
    private Long buyerSignEntityId;

    @ApiModelProperty("买家主体名称")
    private String buyerEntityName;

    @ApiModelProperty("卖家UserId")
    private Long sellerUserId;

    @ApiModelProperty("卖家手机号码")
    private String sellerMobile;

    @ApiModelProperty("卖家经办人名称")
    private String sellerName;

    @ApiModelProperty("卖家主体ID")
    private Long signEntityId;

    @ApiModelProperty("卖家主体名称")
    private String entityName;

    @ApiModelProperty("自定义订单编号")
    private String orderNo;

    @ApiModelProperty("订单种类数目")
    private Integer itemCount;

    @ApiModelProperty("货物数量，sum(item*个数)")
    private Integer goodsCount;

    @ApiModelProperty("合同编号")
    private Long contractId;

    @ApiModelProperty("订单原价")
    private BigDecimal originPrice;

    @ApiModelProperty("优惠的价格")
    private BigDecimal reducePrice;

    @ApiModelProperty("实际价格")
    private BigDecimal price;

    @ApiModelProperty("订单状态,0-草稿，1-已发送，2-买家已签约，3-卖家已签约，4-已作废")
    private Byte orderStatus;

    @ApiModelProperty("其他预定事项")
    private String otherDesc;

    @ApiModelProperty("收货地址")
    private String receiveAddress;

    @ApiModelProperty("买家签约类型")
    public Byte buyerType;

    @ApiModelProperty("买家联系人名称（合同内）")
    public String buyerContactName;

    @ApiModelProperty("买家联系人电话（合同内）")
    public String buyerContactMobile;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("是否测试订单 0否 1是")
    private Byte testOrder;

}