package cn.com.duiba.youqian.center.api.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * `platform_user`
 */
@Data
public class PlatformUser implements Serializable {
    private static final long serialVersionUID = 6502854631829961020L;

    @ApiModelProperty("用户ID")
    private Long userId;

    @ApiModelProperty("用户名称")
    private String userName;

    @ApiModelProperty("账号")
    private String account;

    @ApiModelProperty("密码")
    private String password;

    @ApiModelProperty("手机号码")
    private String mobile;

    @ApiModelProperty("头像")
    private String avatarUrl;

    @ApiModelProperty("性别,0-未知，1-男，2-女")
    private Byte gender;

    @ApiModelProperty("出生日期")
    private Date birthday;

    @ApiModelProperty("实名状态，0-未实名，1-实名中，2-实名完成，3-实名被驳回")
    private Byte authStatus;

    @ApiModelProperty("是否是买家，0-是，1-不是")
    private Byte buyer;

    @ApiModelProperty("城市编号")
    private String countryCode;

    @ApiModelProperty("微信OpenId")
    private String wxOpenId;

    @ApiModelProperty("密码是否修改过，0-未修改/1-已修改")
    private Byte pwdModified;
}