package cn.com.duiba.youqian.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.youqian.center.api.entity.Customer;
import cn.com.duiba.youqian.center.api.request.merchant.SearchCustomerRequest;
import cn.com.duiba.youqian.center.api.result.PageResult;
import cn.com.duiba.youqian.center.api.result.merchant.CustomerVO;

/**
 * @author tengtuox
 * @date 2020/3/6
 * @description
 */
@AdvancedFeignClient
public interface RemoteCustomerService {

    /**
     * 添加客户
     *
     * @param customer customer
     * @return customerId
     */
    Long addCustomer(Customer customer) throws BizException;

    /**
     * 更新客户
     *
     * @param customer customer
     */
    void updateCustomer(Customer customer) throws BizException;

    /**
     * 获取客户详情
     *
     * @param customerId customerId
     * @return CustomerVO
     * @throws BizException 客户不存在
     */
    CustomerVO getCustomer(Long customerId) throws BizException;

    /**
     * 客户列表
     */
    PageResult<CustomerVO> customerPageList(SearchCustomerRequest request) throws BizException;

    /**
     * 删除客户
     *
     * @param customerId customerId
     */
    void deleteCustomer(Long customerId) throws BizException;

}
