package cn.com.duiba.youqian.center.api.request.order;

import cn.com.duiba.youqian.center.api.request.PageRequest;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Set;

/**
 * @author tengtuox
 * @date 2020/2/12
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class SearchBuyerOrderRequest extends PageRequest implements Serializable {
    private static final long serialVersionUID = 3344342736431523159L;

    @ApiModelProperty("订单状态,0-草稿，1-已发送，2-已完成，3-作废")
    private Byte orderStatus;

    @ApiModelProperty("开单账户")
    private String keyword;

    @ApiModelProperty(value = "商户ID（前端不用传）")
    private Long merchantId;

    @ApiModelProperty(value = "当前用户ID（前端不用传）")
    private Long userId;

    @ApiModelProperty(value = "员工ID（前端不用传）")
    private Long employeeId;

    @ApiModelProperty("用户ID Set")
    private Set<Long> userIdSet;
}
