package cn.com.duiba.youqian.center.api.util;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.youqian.center.api.exception.StandardCode;
import com.itextpdf.text.*;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.tool.xml.XMLWorker;
import com.itextpdf.tool.xml.XMLWorkerFontProvider;
import com.itextpdf.tool.xml.XMLWorkerHelper;
import com.itextpdf.tool.xml.html.CssAppliers;
import com.itextpdf.tool.xml.html.CssAppliersImpl;
import com.itextpdf.tool.xml.html.Tags;
import com.itextpdf.tool.xml.parser.XMLParser;
import com.itextpdf.tool.xml.pipeline.css.CSSResolver;
import com.itextpdf.tool.xml.pipeline.css.CssResolverPipeline;
import com.itextpdf.tool.xml.pipeline.end.PdfWriterPipeline;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipeline;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;

import java.io.*;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;

/**
 * @类描述 实现java html 转pdf
 */
@Slf4j
public class PDFUtil {

	public static void main(String[] args) throws BizException, IOException {
		FileUtils.writeByteArrayToFile(new File("d:/test/s1.pdf"),replacePdf(pdfStr));
	}

	static String pdfStr = "<p style=\"text-align:right\">\n" +
			"    <span style=\"font-size: 12px; font-family: 宋体, SimSun;\">合同编号：${orderNo}</span>\n" +
			"</p>\n" +
			"<p style=\"text-align: center;\">\n" +
			"    <strong><span style=\"font-size: 24px; font-family: 宋体, SimSun;\">有签服务合同</span></strong>\n" +
			"</p>\n" +
			"<p>\n" +
			"    <strong><span style=\"font-size: 24px; font-family: 宋体, SimSun;\"><br/></span></strong>\n" +
			"</p>\n" +
			"<p style=\"line-height:150%\">\n" +
			"\t<span style=\"font-family: 宋体, SimSun;\"><strong><span style=\"font-family: 宋体, SimSun; line-height: 150%;\">甲方：${buyerName}</span></strong></span>\n" +
			"</p>\n" +
			"<p style=\"line-height:150%\">\n" +
			"\t<span style=\"line-height: 150%; font-family: 宋体, SimSun;\">联系人：${buyerContact}</span>\n" +
			"</p>\n" +
			"<p style=\"line-height:150%\">\n" +
			"\t<span style=\"line-height: 150%; font-family: 宋体, SimSun;\">联系电话：${buyerMobile}</span>\n" +
			"</p>\n" +
			"<br/>\n" +
			"<p style=\"line-height:150%\">\n" +
			"\t<span style=\"font-family: 宋体, SimSun;\"><strong><span style=\"font-family: 宋体, SimSun; line-height: 150%;\">乙方：杭州友签网络科技有限公司</span></strong></span>\n" +
			"</p>\n" +
			"<p style=\"line-height:150%\">\n" +
			"\t<span style=\"line-height: 150%; font-family: 宋体, SimSun;\">联系地址：浙江省杭州市西湖区文一西路98号数娱大厦5楼</span>\n" +
			"</p>\n" +
			"<p style=\"line-height:150%\">\n" +
			"\t<span style=\"line-height: 150%; font-family: 宋体, SimSun;\">联系人：陈婷</span>\n" +
			"</p>\n" +
			"<p style=\"line-height:150%\">\n" +
			"\t<span style=\"line-height: 150%; font-family: 宋体, SimSun;\">联系电话：0571-28258680</span>\n" +
			"</p>\n" +
			"<br/>\n" +
			"<p style=\"text-indent:32px;line-height:150%\">\n" +
			"    <span style=\"line-height: 150%; font-family: 宋体, SimSun;\">根据《中华人民共和国合同法》及相关法律法规，本着诚实守信、平等互利的原则，<strong><span style=\"line-height: 150%; font-family: 宋体, SimSun; text-decoration: underline;\">甲、乙双方经协商一致，同意以数据电文或双方在纸质合同上盖章的形式订立本合同，并一致认可本合同的法律效力。</span></strong>本合同由《有签服务套餐》和《通用条款》两部分构成，具有同等法律效力。</span>\n" +
			"</p>\n" +
			"<br/>\n" +
			"<p style=\"text-align:center;line-height:150%\">\n" +
			"    <span style=\"font-family: 宋体, SimSun;\"><strong><span style=\"font-family: 宋体, SimSun; line-height: 150%;\">[</span></strong><strong><span style=\"font-family: 宋体, SimSun; line-height: 150%;\">第一部分：有签服务套餐]</span></strong></span>\n" +
			"</p>\n" +
			"<table width=\"100%\" border=\"0\" cellpadding=\"1\" cellspacing=\"2\" style=\"background-color:#000000;\" align=\"center\">\n" +
			"    <tbody>\n" +
			"        <tr class=\"firstRow\" style=\"background-color:#FFFFFF;\">\n" +
			"            <td colspan=\"3\" valign=\"top\" >\n" +
			"                <p style=\"text-align:center;line-height:150%\">\n" +
			"                    <span style=\"font-family: 宋体, SimSun;\"><strong><span style=\"font-family: 宋体, SimSun; line-height: 150%;\">有签服务套餐</span></strong></span>\n" +
			"                </p>\n" +
			"            </td>\n" +
			"        </tr>\n" +
			"        <tr style=\"background-color:#FFFFFF;\">\n" +
			"            <td width=\"20%\" valign=\"top\">\n" +
			"                <p style=\"text-align:center;line-height:150%\">\n" +
			"                    <span style=\"font-family: 宋体, SimSun;\"><strong><span style=\"font-family: 宋体, SimSun; line-height: 150%;\">服务类型</span></strong></span>\n" +
			"                </p>\n" +
			"            </td>\n" +
			"            <td valign=\"top\">\n" +
			"                <p style=\"text-align:center;line-height:150%\">\n" +
			"                    <span style=\"font-family: 宋体, SimSun;\"><strong><span style=\"font-family: 宋体, SimSun; line-height: 150%;\">服务内容</span></strong></span>\n" +
			"                </p>\n" +
			"            </td>\n" +
			"            <td width=\"25%\" valign=\"top\">\n" +
			"                <p style=\"text-align:center;line-height:150%\">\n" +
			"                    <span style=\"font-family: 宋体, SimSun;\"><strong><span style=\"font-family: 宋体, SimSun; line-height: 150%;\">服务说明</span></strong></span>\n" +
			"                </p>\n" +
			"            </td>\n" +
			"        </tr>\n" +
			"        <tr style=\"background-color:#FFFFFF;\">\n" +
			"            <td>\n" +
			"                <p style=\"text-align:center;line-height:150%\">\n" +
			"                    <span style=\"line-height: 150%; font-family: 宋体, SimSun;\">基础服务</span>\n" +
			"                </p>\n" +
			"            </td>\n" +
			"            <td valign=\"top\">\n" +
			"                <p style=\"line-height:150%\">\n" +
			"                    <span style=\"line-height: 150%; font-family: 宋体, SimSun;\">订单创建、合约管理、合约创建、合约签署、合约状态、身份认证、客户管理、角色及权限管理</span>\n" +
			"                </p>\n" +
			"            </td>\n" +
			"            <td rowspan=\"2\">\n" +
			"                <p style=\"line-height:150%\">\n" +
			"                    <span style=\"line-height: 150%; font-family: 宋体, SimSun;\">有效期内，每个有签账户都可使用相应服务，<strong>以开通有签账户后的页面展示为准。</strong></span>\n" +
			"                </p>\n" +
			"            </td>\n" +
			"        </tr>\n" +
			"        <tr style=\"background-color:#FFFFFF;\">\n" +
			"            <td>\n" +
			"                <p style=\"text-align:center;line-height:150%\">\n" +
			"                    <span style=\"line-height: 150%; font-family: 宋体, SimSun;\">支持服务</span>\n" +
			"                </p>\n" +
			"            </td>\n" +
			"            <td valign=\"top\">\n" +
			"                <p style=\"line-height:150%\">\n" +
			"                    <span style=\"font-family: 宋体, SimSun;\"><span style=\"font-family: 宋体, SimSun; line-height: 150%; color: black;\">实时公证</span><span style=\"font-family: 宋体, SimSun; line-height: 150%;\">、专属客户成功顾问、在线客服（工作日9：30-18：30）、远程培训指导</span></span>\n" +
			"                </p>\n" +
			"            </td>\n" +
			"        </tr>\n" +
			"        <tr style=\"background-color:#FFFFFF;\">\n" +
			"            <td>\n" +
			"                <p style=\"text-align:center;line-height:150%\">\n" +
			"                    <span style=\"line-height: 150%; font-family: 宋体, SimSun;\">增值服务</span>\n" +
			"                </p>\n" +
			"            </td>\n" +
			"            <td valign=\"top\">\n" +
			"                <p style=\"line-height:150%\">\n" +
			"                    <span style=\"line-height: 150%; font-family: 宋体, SimSun;\">在线出证、律师服务</span>\n" +
			"                </p>\n" +
			"            </td>\n" +
			"            <td valign=\"top\">\n" +
			"                <p style=\"text-align:center;line-height:150%\">\n" +
			"                    <span style=\"line-height: 150%; font-family: 宋体, SimSun;\">另行收费</span>\n" +
			"                </p>\n" +
			"            </td>\n" +
			"        </tr>\n" +
			"        <tr style=\"background-color:#FFFFFF;\">\n" +
			"            <td colspan=\"3\" valign=\"top\">\n" +
			"                <p style=\"line-height:150%\">\n" +
			"                    <span style=\"line-height: 150%; font-family: 宋体, SimSun;\">本套餐包含[${账户个数}]个有签账户，共[${合同份数}]份电子合同。若前述数量使用完毕，甲方可以通过<span style=\"line-height: 150%; font-family: 宋体, SimSun; color: black;\">在线订购并支付的形式增购。除增购环节另行签署合同外，增购服务仍然适用本合同的约定。</span></span>\n" +
			"                </p>\n" +
			"            </td>\n" +
			"        </tr>\n" +
			"        <tr style=\"background-color:#FFFFFF;\">\n" +
			"            <td colspan=\"3\" valign=\"top\">\n" +
			"                <p style=\"line-height:150%\">\n" +
			"                    <span style=\"line-height: 150%; font-family: 宋体, SimSun;\">服务费用：[${totalGoodsPrice}]（含税价）。一经购买，不支持退款。</span>\n" +
			"                </p>\n" +
			"            </td>\n" +
			"        </tr>\n" +
			"        <tr style=\"background-color:#FFFFFF;\">\n" +
			"            <td colspan=\"3\" valign=\"top\">\n" +
			"                <p style=\"line-height:115%\">\n" +
			"                    <span style=\"font-family: 宋体, SimSun;\"><span style=\"font-family: 宋体, SimSun; line-height: 115%;\">* 服务有效期：自甲乙双方签署本合同之日起[${套餐年数}]年，若甲方有签账户显示的有效期与本合同约定不一致的，则以甲方账户显示期限为准。若服务有效期届满，</span><span style=\"font-family: 宋体, SimSun; color: black;\">甲方没有续费或者电子合同份数已使用完（以先到为准），乙方将关闭甲方账号的签约功能。届时甲方仅有权在乙方关闭签约功能后</span><strong><span style=\"font-family: 宋体, SimSun; color: black;\">[ 5 ]</span></strong><span style=\"font-family: 宋体, SimSun; color: black;\">年内查阅、下载相关法律文件的权限，逾期不下载的，乙方有权删除相关法律文件。</span></span>\n" +
			"                </p>\n" +
			"            </td>\n" +
			"        </tr>\n" +
			"        <tr style=\"background-color:#FFFFFF;\">\n" +
			"            <td colspan=\"3\" valign=\"top\">\n" +
			"                <p style=\"line-height:150%\">\n" +
			"                    <span style=\"line-height: 150%; color: black; font-family: 宋体, SimSun;\">付款方式：自甲乙双方签署本合同后[ 7 ]个工作日内，甲方应以<span style=\"line-height: 150%; color: black; font-family: 宋体, SimSun; text-decoration: underline;\">银行对公转账/或微信支付</span>的方式，向乙方全额支付套餐费用。甲方未按时、足额支付费用的，乙方将不予开通任何服务。</span>\n" +
			"                </p>\n" +
			"            </td>\n" +
			"        </tr>\n" +
			"        <tr style=\"background-color:#FFFFFF;\">\n" +
			"            <td colspan=\"3\" valign=\"top\">\n" +
			"                <p style=\"line-height:150%\">\n" +
			"                    <span style=\"line-height: 150%; color: black; font-family: 宋体, SimSun;\">发票开具：自乙方收到甲方支付的费用后，向甲方开具等额增值税发票。甲方应向乙方提交开票信息，乙方未及时提供开票信息的，甲方不承担延迟开票的责任。</span>\n" +
			"                </p>\n" +
			"            </td>\n" +
			"        </tr>\n" +
			"        <tr style=\"background-color:#FFFFFF;\">\n" +
			"            <td colspan=\"3\" valign=\"top\">\n" +
			"                <p style=\"line-height:150%\">\n" +
			"                    <span style=\"font-family: 宋体, SimSun; line-height: 150%;\">*有签服务使用范围：有签微信小程序。</span>\n" +
			"                </p>\n" +
			"            </td>\n" +
			"        </tr>\n" +
			"    </tbody>\n" +
			"</table>\n" +
			"<br/>\n" +
			"<p style=\"text-align:center;line-height:150%\">\n" +
			"    <span style=\"font-family: 宋体, SimSun;\"><strong><span style=\"font-family: 宋体, SimSun; line-height: 150%;\">[</span></strong><strong><span style=\"font-family: 宋体, SimSun; line-height: 150%;\">第二部分：通用条款]</span></strong></span>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <strong style=\"font-family: 宋体, SimSun;\"><span style=\"line-height: 150%; font-family: 宋体;\">第一条<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-weight: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span></span></strong><strong style=\"font-family: 宋体, SimSun;\"><span style=\"line-height: 150%; font-family: 宋体;\">声明与保证</span></strong>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"font-family: 宋体;\">1.1</span><span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span><span style=\"font-family: 宋体;\">甲方保证具备签订和履行本合同的民事权利能力和民事行为能力，承诺其向乙方提供的信息全部真实有效、准确无误。因甲方提供信息错误、虚假、无效、失效所导致的全部不利后果均由甲方自行承担。</span>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"font-family: 宋体;\">1.2</span><span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span><span style=\"font-family: 宋体;\">乙方对本合同项下的产品有签（有签微信小程序，以下简称“</span><span style=\"font-family: 宋体, SimSun; text-decoration-line: underline;\">有签</span><span style=\"font-family: 宋体;\">”）拥有合法的权利，并对乙方产品的安全性、适用性承担相应责任。</span>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"font-family: 宋体;\">1.3</span><span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span><span style=\"font-family: 宋体;\">双方互相保证在合作期间不得实施任何有损对方利益的行为，包括但不限于侵犯对方的著作权、商标权、名誉权和其他合法权益。若任何一方违反此保证，守约方有权随时单方终止本合同，由违约方承担一切责任并赔偿守约方因此遭受的损失。</span>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <strong style=\"font-family: 宋体, SimSun;\"><span style=\"line-height: 150%; font-family: 宋体;\"><br/></span></strong>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <strong style=\"font-family: 宋体, SimSun;\"><span style=\"line-height: 150%; font-family: 宋体;\">第二条<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-weight: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span></span></strong><strong style=\"font-family: 宋体, SimSun;\"><span style=\"line-height: 150%; font-family: 宋体;\">服务说明</span></strong>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"font-family: 宋体;\">2.1</span><span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span><span style=\"font-family: 宋体;\">有签是为用户提供便捷签约服务的微信小程序，甲方只能通过微信登录并使用相应服务。若新增其他服务形式，乙方将以微信消息及其他有效方式通知甲方。若因甲方微信账号被盗、被封禁而导致无法甲方正常使用本合同项下服务的，乙方不承担任何责任。</span>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"font-family: 宋体;\">2.2</span><span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span><span style=\"font-family: 宋体;\">未经乙方事先书面同意，甲方开通有签服务后不可退款、不可转让、转售给任何第三方。</span>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"font-family: 宋体;\">2.3</span><span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span><span style=\"font-family: 宋体;\">甲方充分认同电子合同的法律效力，理解通过有签所签署的法律文件及其电子签名对签署各方均有法律约束力。</span>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"font-family: 宋体;\">2.4</span><span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span><span style=\"font-family: 宋体;\">使用有签时，甲方应严格按照页面展示、乙方人工指导完成身份认证等流程，并准确填写各项信息。因甲方未完成身份认证而导致的合同签署失败、无效等风险由甲方自行承担。</span>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"font-family: 宋体;\">2.5</span><span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span><span style=\"font-family: 宋体;\">甲方通过有签发起合同签署时，应仔细确认合同内容，确认无误后再发送给合同相对方。合同各方完成签署后，即产生计数/计费信息。因甲方及合同签署方操作失误导致的重复签署，乙方不承担任何责任。</span>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"font-family: 宋体;\">2.6</span><span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span><span style=\"font-family: 宋体;\">甲方可通过有签相关页面查询有签套餐使用情况，包括但不限于合同使用份数、剩余份数。若甲方对套餐使用情况有异议的，应在7个工作日向乙方反馈，乙方应配合说明。甲方未及时反馈的，视为没有异议。</span>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"line-height: 150%; font-family: 宋体;\">2.7<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span></span><span style=\"line-height: 150%; font-family: 宋体;\">甲方通过有签签署的电子合同，自签署完毕后五年内，乙方提供免费保存服务。五年期届满前，甲方有权将电子合同下载至甲方自有存储空间，或者甲方向乙方额外支付费用后，乙方按年继续保存甲方法律文件。超过【五】年，甲方既没有下载文件也不额外支付费用的，乙方有权以删除等方式处理。</span>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"line-height: 150%; font-family: 宋体;\">2.8<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span></span><strong style=\"font-family: 宋体, SimSun;\"><span style=\"text-decoration-line: underline; font-family: 宋体;\">甲方充分理解乙方仅提供技术服务，不对甲方通过有签订立电子合同的内容、合同相对方间的交易的真实性、合法性承担任何审查或其他责任。若甲方与合同相对方发生争议的，乙方仅在本合同服务范围内为甲方提供合同调阅、在线出证、协助公证、律师服务等基础服务及增值服务，涉及另行收费项目的，收费后提供。甲方知悉合同履行是存在风险的，乙方不对争议处理结果承担任何保证责任。</span></strong>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"font-family: 宋体;\">2.9</span><span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span><span style=\"font-family: 宋体;\">依据《电子签名法》的规定，甲方不得通过有签订立如下合同：（1）涉及婚姻、收养、继承等人身关系的；（2）涉及停止供水、供热、供气等公用事业服务的；（3）法律、行政法规规定的不适用电子文书的其他情形。</span>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"font-family: 宋体;\">2.10为了给甲方更好的服务体验，乙方将不时更新、升级有签，而无需另行告知甲方。甲方理解并同意，有签可能会集成第三方的技术服务，如涉及第三方技术服务，乙方将在相应页面告知相关服务规则，甲方应予以遵守。</span>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <strong style=\"font-family: 宋体, SimSun;\"><span style=\"line-height: 150%; font-family: 宋体;\"><br/></span></strong>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <strong style=\"font-family: 宋体, SimSun;\"><span style=\"line-height: 150%; font-family: 宋体;\">第三条<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-weight: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span></span></strong><strong style=\"font-family: 宋体, SimSun;\"><span style=\"line-height: 150%; font-family: 宋体;\">知识产权与保密条款</span></strong>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"font-family: 宋体;\">3.1</span><span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span><span style=\"font-family: 宋体;\">除根据合同的明示而给予甲方的有限使用许可以及本合同另行约定外，乙方拥有有签的所有权、运营权及所有相关的知识产权。甲方承诺尊重及不以任何方式侵害乙方的所有权及知识产权。</span>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"font-family: 宋体;\">3.2</span><span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span><span style=\"font-family: 宋体;\">本合同的内容，以及在本合同签订及履行的过程中一方从对方合法获取的对方未通过公开途径披露的任何信息，均为本合同项下的保密信息。甲方未通过公开途径披露的任何数据，均为甲方的保密信息。</span>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"font-family: 宋体;\">3.3</span><span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span><span style=\"font-family: 宋体;\">一方应妥善保管对方的所有保密信息使之不被泄漏、披露，并应以保护其自有的保密信息同等谨慎的程度保护对方的保密信息。未经对方事先书面同意，一方不得使用或披露对方的任何保密信息，但以下情形除外：（1）一方根据法律规定或有权机关要求在规定或要求的范围内披露对方保密信息；（2）一方为履行本合同之必要向其雇员、董事、顾问等在合理及必要的范围内披露，该等情形下，该方应确保其接受披露的雇员、董事、顾问等履行不低于本合同约定的保密义务，并应对该等人员履行保密义务的行为向对方承担责任。</span>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"font-family: 宋体;\">3.4</span><span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span><span style=\"font-family: 宋体;\">一方在本合同项下承担的保密义务在本合同因任何原因终止后继续有效，直至相关保密信息通过合法途径进入公众领域。</span>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"font-family: 宋体;\">3.5</span><span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span><span style=\"font-family: 宋体;\">乙方可为自身对外宣传、开展营销活动等目的披露甲乙双方存在合作关系，甲方同意乙方在该等宣传、营销等活动中使用甲方的名称、字号、LOGO、标志等，但乙方使用时须确保甲方名称、字号、LOGO、标志等的完整性。</span>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <strong style=\"font-family: 宋体, SimSun;\"><span style=\"line-height: 150%; font-family: 宋体;\"><br/></span></strong>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <strong style=\"font-family: 宋体, SimSun;\"><span style=\"line-height: 150%; font-family: 宋体;\">第四条<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-weight: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span></span></strong><strong style=\"font-family: 宋体, SimSun;\"><span style=\"line-height: 150%; font-family: 宋体;\">廉洁条款</span></strong>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"font-family: 宋体;\">4.1</span><span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span><span style=\"font-family: 宋体;\">甲乙双方应严格遵守法律法规有关禁止商业贿赂行为之规定，坚决拒绝商业贿赂、行贿及其他不正当商业行为。本合同所指的商业贿赂是指，任一方为获取与相对方的合作及合作的利益，给予相对方员工的一切精神及物质上直接或间接的馈赠，如现金、回扣、娱乐、旅游等。</span>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"font-family: 宋体;\">4.2</span><span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span><span style=\"font-family: 宋体;\">任一方违反本合同约定，贿赂相对方任何员工，以图获取任何不正当商业利益或更特殊的商业待遇或不配合相对方查处其员工的受贿行为的，相对方有权立即解除本合同，停止与违约方在其他合同项下的部分或全部合作，赔偿相对方因此遭受的损失，同时违约方应向相对方支付合同款项的五倍作为违约金。情节严重、造成重大经济损失的，相对方将依法移交司法机关处理。</span>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <strong style=\"font-family: 宋体, SimSun;\"><span style=\"line-height: 150%; font-family: 宋体;\"><br/></span></strong>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <strong style=\"font-family: 宋体, SimSun;\"><span style=\"line-height: 150%; font-family: 宋体;\">第五条<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-weight: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span></span></strong><strong style=\"font-family: 宋体, SimSun;\"><span style=\"line-height: 150%; font-family: 宋体;\">数据安全与个人信息保护</span></strong>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"font-family: 宋体, SimSun;\">为了对甲方及合同相对方进行身份认证，甲方同意按照有签页面提示向乙方提供相应信息，并授权乙方将该等信息提供给相应认证机构（以有签页面展示的《隐私政策》为准）。乙方承诺遵守网络安全与个人信息保护相关的国家法律法规、规章、行业标准以及其他政策的要求，防止数据遭到未经授权访问、泄露、滥用、篡改、损坏或丢失。同时，乙方承诺采取合理可行的信息保护措施，包括但不限于信息加密、数据备份、访问权限控制等，保护甲方、有签服务使用者的数据安全。若乙方违反上述承诺，应独立承担相应法律责任。</span>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <strong style=\"font-family: 宋体, SimSun;\"><span style=\"line-height: 150%; font-family: 宋体;\"><br/></span></strong>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <strong style=\"font-family: 宋体, SimSun;\"><span style=\"line-height: 150%; font-family: 宋体;\">第六条<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-weight: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span></span></strong><strong style=\"font-family: 宋体, SimSun;\"><span style=\"line-height: 150%; font-family: 宋体;\">不可抗力、免责与责任限制</span></strong>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"font-family: 宋体;\">6.1</span><span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span><span style=\"font-family: 宋体;\">涉及到互联网服务，可能会受到各个环节不稳定因素的影响，尽管乙方已采取安全防卫措施，仍可能因互联网和电子通信固有的缺陷以及本合同任何一方无法合理控制的事件（包括但不限于自然灾害、暴乱、终端病毒、黑客攻击、网络故障、微信故障等）而发生中止、中断、延误、使用限制或使用不能。甲方在此同意承担以上风险，同意因上述风险事件的实际发生影响到服务的正常运行时，乙方无须向甲方承担责任。乙方承诺在上述风险事件发生后尽合理商业努力尽快恢复正常服务。</span>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <strong style=\"font-family: 宋体, SimSun;\"><span style=\"line-height: 150%; font-family: 宋体;\">6.2 </span></strong><strong style=\"font-family: 宋体, SimSun;\"><span style=\"line-height: 150%; font-family: 宋体;\">因甲方不具备签订和履行本合同的民事权利能力和民事行为能力，或提交的身份认证资料错误、虚假、无效、失效，或未能妥善保管其有签账户，所导致的电子合同效力瑕疵、无效，乙方不承担责任。</span></strong>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <strong style=\"font-family: 宋体, SimSun;\"><span style=\"font-family: 宋体;\">6.3 </span></strong><strong style=\"font-family: 宋体, SimSun;\"><span style=\"text-decoration-line: underline; font-family: 宋体;\">无论何种情形，乙方对甲方所承担的违约赔偿责任总额不超过违约行为发生时过往12个自然月甲方就该违约行为所对应的产品及/或服务已支付的服务费用总额。</span></strong>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <strong style=\"font-family: 宋体, SimSun;\"><span style=\"line-height: 150%; font-family: 宋体;\"><br/></span></strong>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <strong style=\"font-family: 宋体, SimSun;\"><span style=\"line-height: 150%; font-family: 宋体;\">第七条<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-weight: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span></span></strong><strong style=\"font-family: 宋体, SimSun;\"><span style=\"line-height: 150%; font-family: 宋体;\">争议解决</span></strong>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"font-family: 宋体, SimSun;\">若甲乙双方就本合同内容或其执行发生任何争议，双方应进行友好协商；无法达成一致的，双方同意将争议提交杭州仲裁委员会按照其仲裁规则裁决。仲裁裁决是终局的，对各方均有约束力。任何一方对与本合同有关的全部争议及仲裁等事项负有保密义务。一方违反约定披露、泄露的，应按照本合同金额的五倍向守约方支付违约金。</span>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <strong style=\"font-family: 宋体, SimSun;\"><span style=\"line-height: 150%; font-family: 宋体;\"><br/></span></strong>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <strong style=\"font-family: 宋体, SimSun;\"><span style=\"line-height: 150%; font-family: 宋体;\">第八条<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-weight: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span></span></strong><strong style=\"font-family: 宋体, SimSun;\"><span style=\"line-height: 150%; font-family: 宋体;\">合同的解除与终止</span></strong>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"font-family: 宋体;\">8.1</span><span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span><span style=\"font-family: 宋体;\">甲方有权以书面形式通知乙方单方解除本合同，但已支付的费用不予退还。合同解除后，尚未履行的部分终止履行，已履行完毕的事项仍然适用本合同的约定。</span>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"font-family: 宋体;\">8.2</span><span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span><span style=\"font-family: 宋体;\">甲方未按时付款超过30个自然日的，则乙方有权以书面通知的形式单方解除本合同。</span>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <strong style=\"font-family: 宋体, SimSun;\"><span style=\"line-height: 150%; font-family: 宋体;\"><br/></span></strong>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <strong style=\"font-family: 宋体, SimSun;\"><span style=\"line-height: 150%; font-family: 宋体;\">第九条<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-weight: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span></span></strong><strong style=\"font-family: 宋体, SimSun;\"><span style=\"line-height: 150%; font-family: 宋体;\">其他</span></strong>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"font-family: 宋体;\">9.1</span><span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span><span style=\"font-family: 宋体;\">甲乙双方确认本合同文首所载联系地址、联系方式等，系各自的有效送达地址和业务联系方式，适用于本合同中提及的以及与本合同有关的书面通知、业务事项确认、法律文书等送达。如任一方上述联系信息发生变化，应当在发生变化前至少5个工作日通过原有联系方式通知另一方，否则应当承担由此产生的后果和法律责任。</span>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"font-family: 宋体;\">9.2</span><span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span><span style=\"font-family: 宋体;\">本合同通过数据电文或双方在纸质合同上盖章的形式订立，均具有同等效力，自甲、乙签署/盖章后生效。</span>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"font-family: 宋体;\">9.3</span><span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-stretch: normal; font-size: 9px; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp; </span><span style=\"font-family: 宋体;\">本合同未尽事宜，甲乙双方应以补充合同的形式另行约定，补充合同与本合同具有同等法律效力。</span>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"font-family: 宋体, SimSun;\">（以下无正文）</span>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"font-family: 宋体, SimSun; text-indent: 32px;\"><br/></span>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"font-family: 宋体, SimSun; text-indent: 32px;\">本合同由以下各方签署：</span>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <strong style=\"font-family: 宋体, SimSun; text-indent: 32px;\"><span style=\"line-height: 150%;\">甲方（签字/盖章）：</span></strong>\n" +
			"</p>\n" +
			"<p style=\"line-height: 150%;\">\n" +
			"    <span style=\"font-family: 宋体, SimSun; text-decoration-line: underline;\">甲方确认：具备签署本合同的资格与能力，充分理解本合同中的全部内容，尤其是以加黑、加粗、下划线显著标识的内容，愿意签署本合同。</span><br/>\n" +
			"</p>\n" +
			"<p style=\"line-height:150%\">\n" +
			"    <br/>\n" +
			"</p>\n" +
			"<p style=\"line-height:150%\">\n" +
			"    <br/>\n" +
			"</p>\n" +
			"<p style=\"line-height:150%\">\n" +
			"    <strong style=\"font-family: 宋体, SimSun; text-indent: 32px;\"><span style=\"line-height: 150%;\">乙方（盖章）：杭州友签网络科技有限公司</span></strong>\n" +
			"</p>\n" +
			"<p style=\"line-height:150%\">\n" +
			"    <span style=\"font-family: 宋体, SimSun; text-decoration-line: underline; text-indent: 32px;\">乙方确认：具备签署本合同的资格与能力，愿意按照本合同约定为甲方提供相应服务。</span>\n" +
			"</p>\n" +
			"<p style=\"line-height:150%\">\n" +
			"    <span style=\"font-family: 宋体, SimSun; text-indent: 32px;\"><br/></span>\n" +
			"</p>\n" +
			"<p style=\"line-height:150%\">\n" +
			"    <span style=\"font-family: 宋体, SimSun; text-indent: 32px;\">乙方收款账户如下：</span>\n" +
			"</p>\n" +
			"<p style=\"line-height:150%\">\n" +
			"    <span style=\"font-family: 宋体, SimSun; text-indent: 32px;\">企业名称：杭州友签网络科技有限公司</span>\n" +
			"</p>\n" +
			"<p style=\"line-height:150%\">\n" +
			"    <span style=\"font-family: 宋体, SimSun; text-indent: 32px;\">开户银行：华夏银行杭州分行凤起支行</span>\n" +
			"</p>\n" +
			"<p style=\"line-height:150%\">\n" +
			"    <span style=\"font-family: 宋体, SimSun; text-indent: 32px;\">银行账户：10453000000668766</span>\n" +
			"</p>\n" +
			"<p style=\"text-indent:32px;line-height:150%\">\n" +
			"    <span style=\"line-height: 150%; font-family: 宋体, SimSun;\">&nbsp;</span>\n" +
			"</p>\n" +
			"<p style=\"text-indent:32px;line-height:150%\">\n" +
			"    <span style=\"line-height: 150%; font-family: 宋体, SimSun;\">&nbsp;</span>\n" +
			"</p>\n" +
			"<p style=\"line-height:150%\">\n" +
			"    <span style=\"line-height: 150%; font-family: 宋体, SimSun;\">&nbsp;</span>\n" +
			"</p>\n" +
			"<p>\n" +
			"    <br/>\n" +
			"</p>";

	public static byte[] replacePdf(String xhtml) throws BizException {
		ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

		// step 1
		Document document = new Document(PageSize.A4);

		// step 2
		PdfWriter writer;
		try {
			writer = PdfWriter.getInstance(document, outputStream);
		} catch (DocumentException e) {
			log.error("HTML转换PDF异常", e);
			throw new BizException("HTML转换PDF异常").withCode(StandardCode.UNKNOWN_ERROR.getStrCode());
		}

		// step 3
		document.open();

		// step 4
		XMLWorkerFontProvider fontProvider = new MyFontProvider("/fonts/SimSun.ttf", "Identity-H");

		// 使用我们的字体提供器，并将其设置为unicode字体样式
		CssAppliers cssAppliers = new CssAppliersImpl(fontProvider);

		// CSS
		CSSResolver cssResolver = XMLWorkerHelper.getInstance().getDefaultCssResolver(true);

		// HTML
		HtmlPipelineContext htmlContext = new HtmlPipelineContext(cssAppliers);
		htmlContext.setTagFactory(Tags.getHtmlTagProcessorFactory());

		// Pipelines
		PdfWriterPipeline pdf = new PdfWriterPipeline(document, writer);
		HtmlPipeline html = new HtmlPipeline(htmlContext, pdf);
		CssResolverPipeline css = new CssResolverPipeline(cssResolver, html);

		// XML Worker
		XMLWorker worker = new XMLWorker(css, true);
		XMLParser p = new XMLParser(worker);
		try {
			p.parse(new ByteArrayInputStream(xhtml.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
		} catch (IOException e) {
			log.error("HTML转换PDF异常", e);
			throw new BizException("HTML转换PDF异常").withCode(StandardCode.UNKNOWN_ERROR.getStrCode());
		} finally {
			// step 5
			try {
				document.close();
				outputStream.close();
			} catch (Exception e) {
				//ignore
			}
		}

		return outputStream.toByteArray();
	}

	/**
	 * 获取PDF 总页数
	 */
	public static int getPages(byte[] pdfByte) {
		//2 加载PDF
		PDDocument pdDocument = null;
		try {
			pdDocument = PDDocument.load(pdfByte);
			// 3 获取页码
			return pdDocument.getNumberOfPages();
		} catch (IOException e) {
			log.error("IO exception:[{}]",e);
		}finally {
			try {
				if (pdDocument != null) {
					pdDocument.close();
				}
			} catch (IOException e) {
				log.error("IO exception:[{}]",e);
			}
		}
		return 0;
	}

	/**
	 * 返回PDF 最后一页的信息
	 * @param pdfData PDF byte值
	 * @return obj[0] 页数,obj[1] 最后一页的行数
	 */
	public static int[] getLastPage(byte[] pdfData){
		//2 加载PDF
		int[] obj = new int[2];
		PDDocument pdDocument;
		int pages;
		String content;
		try {
			pdDocument = PDDocument.load(pdfData);
			// 3 获取页码
			pages = pdDocument.getNumberOfPages();
			// 4 读文本内容
			PDFTextStripper stripper=new PDFTextStripper();
			// 5 设置按顺序输出,返回最后一页的内容
			stripper.setSortByPosition(true);
			stripper.setStartPage(pages);
			stripper.setEndPage(pages);
			content = stripper.getText(pdDocument);
			pdDocument.close();
			obj[0] = pages;
			obj[1] = getPDFLine(content);
		} catch (IOException e) {
			log.error("IO exception:[{}]",e);
		}
		return obj;
	}

	/**
	 * PDF 内容获取行数
	 */
	public static int getPDFLine(String content){
		int line = 0;
		char[] chars = content.toCharArray();
		for(int i=0;i<chars.length;i++){
			if(chars[i] == '\n'){
				line ++;
			}
		}
		return line;
	}

    /**
     * 根据pdf转为html文件
	 * @param writePath
     * @param content
	 */
	public static void replaceHtml(String  writePath,String content) {
		try {
			if (StringUtils.contains(writePath, ".pdf")) {
				writePath = StringUtils.substringBefore(writePath, ".pdf") + ".html";
			}
			Files.write(Paths.get(writePath), content.getBytes("UTF-8"));
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 *
	 */
	public void downloadLocalPDF(byte[] response_str,String fileName) throws IOException {
		FileOutputStream fileOutputStream = new FileOutputStream(fileName);//存储路径，例：F://test//1.pdf
		IOUtils.write(response_str, fileOutputStream);
	}

	/**
	 * 辅助方法，byte数组保存为本地文件
	 * @param buf
	 * @param buf
	 * @param fileName
	 */
	public static String byte2File(byte[] buf, String fileName) {
		String filePath = "C:\\Users\\Duiba\\Desktop\\";
		BufferedOutputStream bos = null;
		FileOutputStream fos = null;
		File file;
		try {
			File dir = new File(filePath);
			if (!dir.exists()) {
				dir.mkdirs();
			}
			file = new File(filePath + File.separator + fileName);
			fos = new FileOutputStream(file);
			bos = new BufferedOutputStream(fos);
			bos.write(buf);
		}catch (Exception e) {
			e.printStackTrace();
		}finally{
			if(bos != null) {
				try {
					bos.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
			if (fos != null) {
				try {
					fos.close();
				}catch (IOException e){
					e.printStackTrace();
				}
			}
		}

		return filePath + File.separator + fileName;
	}

	private static class MyFontProvider extends XMLWorkerFontProvider {
		private String fontName = null;
		private String enCoding = null;

		public MyFontProvider(String fontName, String enCoding) {
			super(null, null);
			this.fontName = fontName;
			this.enCoding = enCoding;
		}

		@Override
		public Font getFont(final String fontname, final String encoding, final boolean embedded, final float size, final int style, final BaseColor color) {
			if (this.fontName == null) {
				return getFont(fontname, encoding, size, style);
			}

			BaseFont bf = null;
			try {
				bf = BaseFont.createFont(fontName, enCoding, BaseFont.NOT_EMBEDDED);
			} catch (DocumentException | IOException e) {
				throw new RuntimeException(e.getMessage(), e);
			}

			Font font = new Font(bf, size, style, color);
			font.setColor(color);
			return font;
		}
	}

}