/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.api.model.dto.report.businessReport;

import cn.com.duiba.cloud.manage.service.api.model.dto.report.businessReport.ProvinceRetailerDTO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class RegionRetailerDTO
implements Serializable {
    private static final long serialVersionUID = -5614725328857916568L;
    List<ProvinceRetailerDTO> provinceRetailerList;
    private String regionName;
    private Long userCountNotFollowingTarget;
    private Long userIncreaseCountNotFollowingTarget;
    private Long userCount;
    private Long userCountNotFollowing;
    private Long userIncreaseCountNotFollowing;
    private BigDecimal targetProgress;
    private String targetProgressStr;
    private Long inviteAccumulativeCount;
    private Long inviteSingleMonthCount;
    private Long phwdAccumulativeCount;
    private Long phwdSingleMonthCount;
    private Long selfDisciplineAccumulativeCount;
    private Long selfDisciplineSingleMonthCount;
    private Long leagueAccumulativeCount;
    private Long leagueSingleMonthCount;
    private Long getCustomersAccumulativeCount;
    private Long getCustomersSingleMonthCount;
    private Long scanCodeAccumulativeCount;
    private Long scanCodeSingleMonthCount;
    private Long othersAccumulativeCount;
    private Long othersSingleMonthCount;

    public void setTargetProgress(BigDecimal targetProgress) {
        this.targetProgress = targetProgress;
        if (targetProgress != null) {
            this.targetProgressStr = targetProgress.toPlainString();
        }
    }

    public void summary() {
        List<ProvinceRetailerDTO> provinceRetailerList = this.provinceRetailerList;
        if (CollectionUtils.isEmpty(provinceRetailerList)) {
            return;
        }
        provinceRetailerList.forEach(provinceRetailerDTO -> {
            this.userCount = this.add(provinceRetailerDTO.getUserCount(), this.userCount);
            this.userCountNotFollowing = this.add(provinceRetailerDTO.getUserCountNotFollowing(), this.userCountNotFollowing);
            this.userIncreaseCountNotFollowing = this.add(provinceRetailerDTO.getUserIncreaseCountNotFollowing(), this.userIncreaseCountNotFollowing);
            this.inviteAccumulativeCount = this.add(provinceRetailerDTO.getInviteAccumulativeCount(), this.inviteAccumulativeCount);
            this.inviteSingleMonthCount = this.add(provinceRetailerDTO.getInviteSingleMonthCount(), this.inviteSingleMonthCount);
            this.phwdAccumulativeCount = this.add(provinceRetailerDTO.getPhwdAccumulativeCount(), this.phwdAccumulativeCount);
            this.phwdSingleMonthCount = this.add(this.phwdSingleMonthCount, provinceRetailerDTO.getPhwdSingleMonthCount());
            this.selfDisciplineAccumulativeCount = this.add(this.selfDisciplineAccumulativeCount, provinceRetailerDTO.getSelfDisciplineAccumulativeCount());
            this.selfDisciplineSingleMonthCount = this.add(this.selfDisciplineSingleMonthCount, provinceRetailerDTO.getSelfDisciplineSingleMonthCount());
            this.leagueAccumulativeCount = this.add(this.leagueAccumulativeCount, provinceRetailerDTO.getLeagueAccumulativeCount());
            this.leagueSingleMonthCount = this.add(this.leagueSingleMonthCount, provinceRetailerDTO.getLeagueSingleMonthCount());
            this.getCustomersAccumulativeCount = this.add(this.getCustomersAccumulativeCount, provinceRetailerDTO.getGetCustomersAccumulativeCount());
            this.getCustomersSingleMonthCount = this.add(this.getCustomersSingleMonthCount, provinceRetailerDTO.getGetCustomersSingleMonthCount());
            this.scanCodeAccumulativeCount = this.add(this.scanCodeAccumulativeCount, provinceRetailerDTO.getScanCodeAccumulativeCount());
            this.scanCodeSingleMonthCount = this.add(this.scanCodeSingleMonthCount, provinceRetailerDTO.getScanCodeSingleMonthCount());
            this.othersAccumulativeCount = this.add(this.othersAccumulativeCount, provinceRetailerDTO.getOthersAccumulativeCount());
            this.othersSingleMonthCount = this.add(this.othersSingleMonthCount, provinceRetailerDTO.getOthersSingleMonthCount());
        });
    }

    public void calculateSchedule() {
        this.userIncreaseCountNotFollowing = this.userIncreaseCountNotFollowing == null ? 0L : this.userIncreaseCountNotFollowing;
        this.userIncreaseCountNotFollowingTarget = this.userIncreaseCountNotFollowingTarget == null ? 0L : this.userIncreaseCountNotFollowingTarget;
        this.setTargetProgress(this.calculateSchedule(new BigDecimal(this.userIncreaseCountNotFollowing), new BigDecimal(this.userIncreaseCountNotFollowingTarget)));
        this.provinceRetailerList.forEach(provinceRetailerDTO -> {
            BigDecimal actualValue = new BigDecimal(provinceRetailerDTO.getUserIncreaseCountNotFollowing() == null ? 0L : provinceRetailerDTO.getUserIncreaseCountNotFollowing());
            BigDecimal targetValue = new BigDecimal(provinceRetailerDTO.getUserIncreaseCountNotFollowingTarget() == null ? 0L : provinceRetailerDTO.getUserIncreaseCountNotFollowingTarget());
            provinceRetailerDTO.setTargetProgress(this.calculateSchedule(actualValue, targetValue));
        });
    }

    private BigDecimal calculateSchedule(BigDecimal actualValue, BigDecimal targetValue) {
        boolean targetFlag;
        BigDecimal progress = new BigDecimal(0L).setScale(2, 4);
        boolean actualFlag = actualValue == null || actualValue.compareTo(new BigDecimal(0)) == 0;
        boolean bl = targetFlag = targetValue == null || targetValue.compareTo(new BigDecimal(0)) == 0;
        if (targetFlag || actualFlag) {
            return progress;
        }
        progress = actualValue.multiply(new BigDecimal(100)).divide(targetValue, 2, 5).setScale(2, 5);
        return progress;
    }

    private Long add(Long first, Long second) {
        long l = first == null ? 0L : first;
        long l1 = second == null ? 0L : second;
        return l + l1;
    }

    public static RegionRetailerDTOBuilder builder() {
        return new RegionRetailerDTOBuilder();
    }

    public List<ProvinceRetailerDTO> getProvinceRetailerList() {
        return this.provinceRetailerList;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public Long getUserCountNotFollowingTarget() {
        return this.userCountNotFollowingTarget;
    }

    public Long getUserIncreaseCountNotFollowingTarget() {
        return this.userIncreaseCountNotFollowingTarget;
    }

    public Long getUserCount() {
        return this.userCount;
    }

    public Long getUserCountNotFollowing() {
        return this.userCountNotFollowing;
    }

    public Long getUserIncreaseCountNotFollowing() {
        return this.userIncreaseCountNotFollowing;
    }

    public BigDecimal getTargetProgress() {
        return this.targetProgress;
    }

    public String getTargetProgressStr() {
        return this.targetProgressStr;
    }

    public Long getInviteAccumulativeCount() {
        return this.inviteAccumulativeCount;
    }

    public Long getInviteSingleMonthCount() {
        return this.inviteSingleMonthCount;
    }

    public Long getPhwdAccumulativeCount() {
        return this.phwdAccumulativeCount;
    }

    public Long getPhwdSingleMonthCount() {
        return this.phwdSingleMonthCount;
    }

    public Long getSelfDisciplineAccumulativeCount() {
        return this.selfDisciplineAccumulativeCount;
    }

    public Long getSelfDisciplineSingleMonthCount() {
        return this.selfDisciplineSingleMonthCount;
    }

    public Long getLeagueAccumulativeCount() {
        return this.leagueAccumulativeCount;
    }

    public Long getLeagueSingleMonthCount() {
        return this.leagueSingleMonthCount;
    }

    public Long getGetCustomersAccumulativeCount() {
        return this.getCustomersAccumulativeCount;
    }

    public Long getGetCustomersSingleMonthCount() {
        return this.getCustomersSingleMonthCount;
    }

    public Long getScanCodeAccumulativeCount() {
        return this.scanCodeAccumulativeCount;
    }

    public Long getScanCodeSingleMonthCount() {
        return this.scanCodeSingleMonthCount;
    }

    public Long getOthersAccumulativeCount() {
        return this.othersAccumulativeCount;
    }

    public Long getOthersSingleMonthCount() {
        return this.othersSingleMonthCount;
    }

    public void setProvinceRetailerList(List<ProvinceRetailerDTO> provinceRetailerList) {
        this.provinceRetailerList = provinceRetailerList;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public void setUserCountNotFollowingTarget(Long userCountNotFollowingTarget) {
        this.userCountNotFollowingTarget = userCountNotFollowingTarget;
    }

    public void setUserIncreaseCountNotFollowingTarget(Long userIncreaseCountNotFollowingTarget) {
        this.userIncreaseCountNotFollowingTarget = userIncreaseCountNotFollowingTarget;
    }

    public void setUserCount(Long userCount) {
        this.userCount = userCount;
    }

    public void setUserCountNotFollowing(Long userCountNotFollowing) {
        this.userCountNotFollowing = userCountNotFollowing;
    }

    public void setUserIncreaseCountNotFollowing(Long userIncreaseCountNotFollowing) {
        this.userIncreaseCountNotFollowing = userIncreaseCountNotFollowing;
    }

    public void setTargetProgressStr(String targetProgressStr) {
        this.targetProgressStr = targetProgressStr;
    }

    public void setInviteAccumulativeCount(Long inviteAccumulativeCount) {
        this.inviteAccumulativeCount = inviteAccumulativeCount;
    }

    public void setInviteSingleMonthCount(Long inviteSingleMonthCount) {
        this.inviteSingleMonthCount = inviteSingleMonthCount;
    }

    public void setPhwdAccumulativeCount(Long phwdAccumulativeCount) {
        this.phwdAccumulativeCount = phwdAccumulativeCount;
    }

    public void setPhwdSingleMonthCount(Long phwdSingleMonthCount) {
        this.phwdSingleMonthCount = phwdSingleMonthCount;
    }

    public void setSelfDisciplineAccumulativeCount(Long selfDisciplineAccumulativeCount) {
        this.selfDisciplineAccumulativeCount = selfDisciplineAccumulativeCount;
    }

    public void setSelfDisciplineSingleMonthCount(Long selfDisciplineSingleMonthCount) {
        this.selfDisciplineSingleMonthCount = selfDisciplineSingleMonthCount;
    }

    public void setLeagueAccumulativeCount(Long leagueAccumulativeCount) {
        this.leagueAccumulativeCount = leagueAccumulativeCount;
    }

    public void setLeagueSingleMonthCount(Long leagueSingleMonthCount) {
        this.leagueSingleMonthCount = leagueSingleMonthCount;
    }

    public void setGetCustomersAccumulativeCount(Long getCustomersAccumulativeCount) {
        this.getCustomersAccumulativeCount = getCustomersAccumulativeCount;
    }

    public void setGetCustomersSingleMonthCount(Long getCustomersSingleMonthCount) {
        this.getCustomersSingleMonthCount = getCustomersSingleMonthCount;
    }

    public void setScanCodeAccumulativeCount(Long scanCodeAccumulativeCount) {
        this.scanCodeAccumulativeCount = scanCodeAccumulativeCount;
    }

    public void setScanCodeSingleMonthCount(Long scanCodeSingleMonthCount) {
        this.scanCodeSingleMonthCount = scanCodeSingleMonthCount;
    }

    public void setOthersAccumulativeCount(Long othersAccumulativeCount) {
        this.othersAccumulativeCount = othersAccumulativeCount;
    }

    public void setOthersSingleMonthCount(Long othersSingleMonthCount) {
        this.othersSingleMonthCount = othersSingleMonthCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegionRetailerDTO)) {
            return false;
        }
        RegionRetailerDTO other = (RegionRetailerDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ProvinceRetailerDTO> this$provinceRetailerList = this.getProvinceRetailerList();
        List<ProvinceRetailerDTO> other$provinceRetailerList = other.getProvinceRetailerList();
        if (this$provinceRetailerList == null ? other$provinceRetailerList != null : !((Object)this$provinceRetailerList).equals(other$provinceRetailerList)) {
            return false;
        }
        String this$regionName = this.getRegionName();
        String other$regionName = other.getRegionName();
        if (this$regionName == null ? other$regionName != null : !this$regionName.equals(other$regionName)) {
            return false;
        }
        Long this$userCountNotFollowingTarget = this.getUserCountNotFollowingTarget();
        Long other$userCountNotFollowingTarget = other.getUserCountNotFollowingTarget();
        if (this$userCountNotFollowingTarget == null ? other$userCountNotFollowingTarget != null : !((Object)this$userCountNotFollowingTarget).equals(other$userCountNotFollowingTarget)) {
            return false;
        }
        Long this$userIncreaseCountNotFollowingTarget = this.getUserIncreaseCountNotFollowingTarget();
        Long other$userIncreaseCountNotFollowingTarget = other.getUserIncreaseCountNotFollowingTarget();
        if (this$userIncreaseCountNotFollowingTarget == null ? other$userIncreaseCountNotFollowingTarget != null : !((Object)this$userIncreaseCountNotFollowingTarget).equals(other$userIncreaseCountNotFollowingTarget)) {
            return false;
        }
        Long this$userCount = this.getUserCount();
        Long other$userCount = other.getUserCount();
        if (this$userCount == null ? other$userCount != null : !((Object)this$userCount).equals(other$userCount)) {
            return false;
        }
        Long this$userCountNotFollowing = this.getUserCountNotFollowing();
        Long other$userCountNotFollowing = other.getUserCountNotFollowing();
        if (this$userCountNotFollowing == null ? other$userCountNotFollowing != null : !((Object)this$userCountNotFollowing).equals(other$userCountNotFollowing)) {
            return false;
        }
        Long this$userIncreaseCountNotFollowing = this.getUserIncreaseCountNotFollowing();
        Long other$userIncreaseCountNotFollowing = other.getUserIncreaseCountNotFollowing();
        if (this$userIncreaseCountNotFollowing == null ? other$userIncreaseCountNotFollowing != null : !((Object)this$userIncreaseCountNotFollowing).equals(other$userIncreaseCountNotFollowing)) {
            return false;
        }
        BigDecimal this$targetProgress = this.getTargetProgress();
        BigDecimal other$targetProgress = other.getTargetProgress();
        if (this$targetProgress == null ? other$targetProgress != null : !((Object)this$targetProgress).equals(other$targetProgress)) {
            return false;
        }
        String this$targetProgressStr = this.getTargetProgressStr();
        String other$targetProgressStr = other.getTargetProgressStr();
        if (this$targetProgressStr == null ? other$targetProgressStr != null : !this$targetProgressStr.equals(other$targetProgressStr)) {
            return false;
        }
        Long this$inviteAccumulativeCount = this.getInviteAccumulativeCount();
        Long other$inviteAccumulativeCount = other.getInviteAccumulativeCount();
        if (this$inviteAccumulativeCount == null ? other$inviteAccumulativeCount != null : !((Object)this$inviteAccumulativeCount).equals(other$inviteAccumulativeCount)) {
            return false;
        }
        Long this$inviteSingleMonthCount = this.getInviteSingleMonthCount();
        Long other$inviteSingleMonthCount = other.getInviteSingleMonthCount();
        if (this$inviteSingleMonthCount == null ? other$inviteSingleMonthCount != null : !((Object)this$inviteSingleMonthCount).equals(other$inviteSingleMonthCount)) {
            return false;
        }
        Long this$phwdAccumulativeCount = this.getPhwdAccumulativeCount();
        Long other$phwdAccumulativeCount = other.getPhwdAccumulativeCount();
        if (this$phwdAccumulativeCount == null ? other$phwdAccumulativeCount != null : !((Object)this$phwdAccumulativeCount).equals(other$phwdAccumulativeCount)) {
            return false;
        }
        Long this$phwdSingleMonthCount = this.getPhwdSingleMonthCount();
        Long other$phwdSingleMonthCount = other.getPhwdSingleMonthCount();
        if (this$phwdSingleMonthCount == null ? other$phwdSingleMonthCount != null : !((Object)this$phwdSingleMonthCount).equals(other$phwdSingleMonthCount)) {
            return false;
        }
        Long this$selfDisciplineAccumulativeCount = this.getSelfDisciplineAccumulativeCount();
        Long other$selfDisciplineAccumulativeCount = other.getSelfDisciplineAccumulativeCount();
        if (this$selfDisciplineAccumulativeCount == null ? other$selfDisciplineAccumulativeCount != null : !((Object)this$selfDisciplineAccumulativeCount).equals(other$selfDisciplineAccumulativeCount)) {
            return false;
        }
        Long this$selfDisciplineSingleMonthCount = this.getSelfDisciplineSingleMonthCount();
        Long other$selfDisciplineSingleMonthCount = other.getSelfDisciplineSingleMonthCount();
        if (this$selfDisciplineSingleMonthCount == null ? other$selfDisciplineSingleMonthCount != null : !((Object)this$selfDisciplineSingleMonthCount).equals(other$selfDisciplineSingleMonthCount)) {
            return false;
        }
        Long this$leagueAccumulativeCount = this.getLeagueAccumulativeCount();
        Long other$leagueAccumulativeCount = other.getLeagueAccumulativeCount();
        if (this$leagueAccumulativeCount == null ? other$leagueAccumulativeCount != null : !((Object)this$leagueAccumulativeCount).equals(other$leagueAccumulativeCount)) {
            return false;
        }
        Long this$leagueSingleMonthCount = this.getLeagueSingleMonthCount();
        Long other$leagueSingleMonthCount = other.getLeagueSingleMonthCount();
        if (this$leagueSingleMonthCount == null ? other$leagueSingleMonthCount != null : !((Object)this$leagueSingleMonthCount).equals(other$leagueSingleMonthCount)) {
            return false;
        }
        Long this$getCustomersAccumulativeCount = this.getGetCustomersAccumulativeCount();
        Long other$getCustomersAccumulativeCount = other.getGetCustomersAccumulativeCount();
        if (this$getCustomersAccumulativeCount == null ? other$getCustomersAccumulativeCount != null : !((Object)this$getCustomersAccumulativeCount).equals(other$getCustomersAccumulativeCount)) {
            return false;
        }
        Long this$getCustomersSingleMonthCount = this.getGetCustomersSingleMonthCount();
        Long other$getCustomersSingleMonthCount = other.getGetCustomersSingleMonthCount();
        if (this$getCustomersSingleMonthCount == null ? other$getCustomersSingleMonthCount != null : !((Object)this$getCustomersSingleMonthCount).equals(other$getCustomersSingleMonthCount)) {
            return false;
        }
        Long this$scanCodeAccumulativeCount = this.getScanCodeAccumulativeCount();
        Long other$scanCodeAccumulativeCount = other.getScanCodeAccumulativeCount();
        if (this$scanCodeAccumulativeCount == null ? other$scanCodeAccumulativeCount != null : !((Object)this$scanCodeAccumulativeCount).equals(other$scanCodeAccumulativeCount)) {
            return false;
        }
        Long this$scanCodeSingleMonthCount = this.getScanCodeSingleMonthCount();
        Long other$scanCodeSingleMonthCount = other.getScanCodeSingleMonthCount();
        if (this$scanCodeSingleMonthCount == null ? other$scanCodeSingleMonthCount != null : !((Object)this$scanCodeSingleMonthCount).equals(other$scanCodeSingleMonthCount)) {
            return false;
        }
        Long this$othersAccumulativeCount = this.getOthersAccumulativeCount();
        Long other$othersAccumulativeCount = other.getOthersAccumulativeCount();
        if (this$othersAccumulativeCount == null ? other$othersAccumulativeCount != null : !((Object)this$othersAccumulativeCount).equals(other$othersAccumulativeCount)) {
            return false;
        }
        Long this$othersSingleMonthCount = this.getOthersSingleMonthCount();
        Long other$othersSingleMonthCount = other.getOthersSingleMonthCount();
        return !(this$othersSingleMonthCount == null ? other$othersSingleMonthCount != null : !((Object)this$othersSingleMonthCount).equals(other$othersSingleMonthCount));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RegionRetailerDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ProvinceRetailerDTO> $provinceRetailerList = this.getProvinceRetailerList();
        result = result * 59 + ($provinceRetailerList == null ? 43 : ((Object)$provinceRetailerList).hashCode());
        String $regionName = this.getRegionName();
        result = result * 59 + ($regionName == null ? 43 : $regionName.hashCode());
        Long $userCountNotFollowingTarget = this.getUserCountNotFollowingTarget();
        result = result * 59 + ($userCountNotFollowingTarget == null ? 43 : ((Object)$userCountNotFollowingTarget).hashCode());
        Long $userIncreaseCountNotFollowingTarget = this.getUserIncreaseCountNotFollowingTarget();
        result = result * 59 + ($userIncreaseCountNotFollowingTarget == null ? 43 : ((Object)$userIncreaseCountNotFollowingTarget).hashCode());
        Long $userCount = this.getUserCount();
        result = result * 59 + ($userCount == null ? 43 : ((Object)$userCount).hashCode());
        Long $userCountNotFollowing = this.getUserCountNotFollowing();
        result = result * 59 + ($userCountNotFollowing == null ? 43 : ((Object)$userCountNotFollowing).hashCode());
        Long $userIncreaseCountNotFollowing = this.getUserIncreaseCountNotFollowing();
        result = result * 59 + ($userIncreaseCountNotFollowing == null ? 43 : ((Object)$userIncreaseCountNotFollowing).hashCode());
        BigDecimal $targetProgress = this.getTargetProgress();
        result = result * 59 + ($targetProgress == null ? 43 : ((Object)$targetProgress).hashCode());
        String $targetProgressStr = this.getTargetProgressStr();
        result = result * 59 + ($targetProgressStr == null ? 43 : $targetProgressStr.hashCode());
        Long $inviteAccumulativeCount = this.getInviteAccumulativeCount();
        result = result * 59 + ($inviteAccumulativeCount == null ? 43 : ((Object)$inviteAccumulativeCount).hashCode());
        Long $inviteSingleMonthCount = this.getInviteSingleMonthCount();
        result = result * 59 + ($inviteSingleMonthCount == null ? 43 : ((Object)$inviteSingleMonthCount).hashCode());
        Long $phwdAccumulativeCount = this.getPhwdAccumulativeCount();
        result = result * 59 + ($phwdAccumulativeCount == null ? 43 : ((Object)$phwdAccumulativeCount).hashCode());
        Long $phwdSingleMonthCount = this.getPhwdSingleMonthCount();
        result = result * 59 + ($phwdSingleMonthCount == null ? 43 : ((Object)$phwdSingleMonthCount).hashCode());
        Long $selfDisciplineAccumulativeCount = this.getSelfDisciplineAccumulativeCount();
        result = result * 59 + ($selfDisciplineAccumulativeCount == null ? 43 : ((Object)$selfDisciplineAccumulativeCount).hashCode());
        Long $selfDisciplineSingleMonthCount = this.getSelfDisciplineSingleMonthCount();
        result = result * 59 + ($selfDisciplineSingleMonthCount == null ? 43 : ((Object)$selfDisciplineSingleMonthCount).hashCode());
        Long $leagueAccumulativeCount = this.getLeagueAccumulativeCount();
        result = result * 59 + ($leagueAccumulativeCount == null ? 43 : ((Object)$leagueAccumulativeCount).hashCode());
        Long $leagueSingleMonthCount = this.getLeagueSingleMonthCount();
        result = result * 59 + ($leagueSingleMonthCount == null ? 43 : ((Object)$leagueSingleMonthCount).hashCode());
        Long $getCustomersAccumulativeCount = this.getGetCustomersAccumulativeCount();
        result = result * 59 + ($getCustomersAccumulativeCount == null ? 43 : ((Object)$getCustomersAccumulativeCount).hashCode());
        Long $getCustomersSingleMonthCount = this.getGetCustomersSingleMonthCount();
        result = result * 59 + ($getCustomersSingleMonthCount == null ? 43 : ((Object)$getCustomersSingleMonthCount).hashCode());
        Long $scanCodeAccumulativeCount = this.getScanCodeAccumulativeCount();
        result = result * 59 + ($scanCodeAccumulativeCount == null ? 43 : ((Object)$scanCodeAccumulativeCount).hashCode());
        Long $scanCodeSingleMonthCount = this.getScanCodeSingleMonthCount();
        result = result * 59 + ($scanCodeSingleMonthCount == null ? 43 : ((Object)$scanCodeSingleMonthCount).hashCode());
        Long $othersAccumulativeCount = this.getOthersAccumulativeCount();
        result = result * 59 + ($othersAccumulativeCount == null ? 43 : ((Object)$othersAccumulativeCount).hashCode());
        Long $othersSingleMonthCount = this.getOthersSingleMonthCount();
        result = result * 59 + ($othersSingleMonthCount == null ? 43 : ((Object)$othersSingleMonthCount).hashCode());
        return result;
    }

    public String toString() {
        return "RegionRetailerDTO(provinceRetailerList=" + this.getProvinceRetailerList() + ", regionName=" + this.getRegionName() + ", userCountNotFollowingTarget=" + this.getUserCountNotFollowingTarget() + ", userIncreaseCountNotFollowingTarget=" + this.getUserIncreaseCountNotFollowingTarget() + ", userCount=" + this.getUserCount() + ", userCountNotFollowing=" + this.getUserCountNotFollowing() + ", userIncreaseCountNotFollowing=" + this.getUserIncreaseCountNotFollowing() + ", targetProgress=" + this.getTargetProgress() + ", targetProgressStr=" + this.getTargetProgressStr() + ", inviteAccumulativeCount=" + this.getInviteAccumulativeCount() + ", inviteSingleMonthCount=" + this.getInviteSingleMonthCount() + ", phwdAccumulativeCount=" + this.getPhwdAccumulativeCount() + ", phwdSingleMonthCount=" + this.getPhwdSingleMonthCount() + ", selfDisciplineAccumulativeCount=" + this.getSelfDisciplineAccumulativeCount() + ", selfDisciplineSingleMonthCount=" + this.getSelfDisciplineSingleMonthCount() + ", leagueAccumulativeCount=" + this.getLeagueAccumulativeCount() + ", leagueSingleMonthCount=" + this.getLeagueSingleMonthCount() + ", getCustomersAccumulativeCount=" + this.getGetCustomersAccumulativeCount() + ", getCustomersSingleMonthCount=" + this.getGetCustomersSingleMonthCount() + ", scanCodeAccumulativeCount=" + this.getScanCodeAccumulativeCount() + ", scanCodeSingleMonthCount=" + this.getScanCodeSingleMonthCount() + ", othersAccumulativeCount=" + this.getOthersAccumulativeCount() + ", othersSingleMonthCount=" + this.getOthersSingleMonthCount() + ")";
    }

    public RegionRetailerDTO() {
    }

    public RegionRetailerDTO(List<ProvinceRetailerDTO> provinceRetailerList, String regionName, Long userCountNotFollowingTarget, Long userIncreaseCountNotFollowingTarget, Long userCount, Long userCountNotFollowing, Long userIncreaseCountNotFollowing, BigDecimal targetProgress, String targetProgressStr, Long inviteAccumulativeCount, Long inviteSingleMonthCount, Long phwdAccumulativeCount, Long phwdSingleMonthCount, Long selfDisciplineAccumulativeCount, Long selfDisciplineSingleMonthCount, Long leagueAccumulativeCount, Long leagueSingleMonthCount, Long getCustomersAccumulativeCount, Long getCustomersSingleMonthCount, Long scanCodeAccumulativeCount, Long scanCodeSingleMonthCount, Long othersAccumulativeCount, Long othersSingleMonthCount) {
        this.provinceRetailerList = provinceRetailerList;
        this.regionName = regionName;
        this.userCountNotFollowingTarget = userCountNotFollowingTarget;
        this.userIncreaseCountNotFollowingTarget = userIncreaseCountNotFollowingTarget;
        this.userCount = userCount;
        this.userCountNotFollowing = userCountNotFollowing;
        this.userIncreaseCountNotFollowing = userIncreaseCountNotFollowing;
        this.targetProgress = targetProgress;
        this.targetProgressStr = targetProgressStr;
        this.inviteAccumulativeCount = inviteAccumulativeCount;
        this.inviteSingleMonthCount = inviteSingleMonthCount;
        this.phwdAccumulativeCount = phwdAccumulativeCount;
        this.phwdSingleMonthCount = phwdSingleMonthCount;
        this.selfDisciplineAccumulativeCount = selfDisciplineAccumulativeCount;
        this.selfDisciplineSingleMonthCount = selfDisciplineSingleMonthCount;
        this.leagueAccumulativeCount = leagueAccumulativeCount;
        this.leagueSingleMonthCount = leagueSingleMonthCount;
        this.getCustomersAccumulativeCount = getCustomersAccumulativeCount;
        this.getCustomersSingleMonthCount = getCustomersSingleMonthCount;
        this.scanCodeAccumulativeCount = scanCodeAccumulativeCount;
        this.scanCodeSingleMonthCount = scanCodeSingleMonthCount;
        this.othersAccumulativeCount = othersAccumulativeCount;
        this.othersSingleMonthCount = othersSingleMonthCount;
    }

    public static class RegionRetailerDTOBuilder {
        private List<ProvinceRetailerDTO> provinceRetailerList;
        private String regionName;
        private Long userCountNotFollowingTarget;
        private Long userIncreaseCountNotFollowingTarget;
        private Long userCount;
        private Long userCountNotFollowing;
        private Long userIncreaseCountNotFollowing;
        private BigDecimal targetProgress;
        private String targetProgressStr;
        private Long inviteAccumulativeCount;
        private Long inviteSingleMonthCount;
        private Long phwdAccumulativeCount;
        private Long phwdSingleMonthCount;
        private Long selfDisciplineAccumulativeCount;
        private Long selfDisciplineSingleMonthCount;
        private Long leagueAccumulativeCount;
        private Long leagueSingleMonthCount;
        private Long getCustomersAccumulativeCount;
        private Long getCustomersSingleMonthCount;
        private Long scanCodeAccumulativeCount;
        private Long scanCodeSingleMonthCount;
        private Long othersAccumulativeCount;
        private Long othersSingleMonthCount;

        RegionRetailerDTOBuilder() {
        }

        public RegionRetailerDTOBuilder provinceRetailerList(List<ProvinceRetailerDTO> provinceRetailerList) {
            this.provinceRetailerList = provinceRetailerList;
            return this;
        }

        public RegionRetailerDTOBuilder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public RegionRetailerDTOBuilder userCountNotFollowingTarget(Long userCountNotFollowingTarget) {
            this.userCountNotFollowingTarget = userCountNotFollowingTarget;
            return this;
        }

        public RegionRetailerDTOBuilder userIncreaseCountNotFollowingTarget(Long userIncreaseCountNotFollowingTarget) {
            this.userIncreaseCountNotFollowingTarget = userIncreaseCountNotFollowingTarget;
            return this;
        }

        public RegionRetailerDTOBuilder userCount(Long userCount) {
            this.userCount = userCount;
            return this;
        }

        public RegionRetailerDTOBuilder userCountNotFollowing(Long userCountNotFollowing) {
            this.userCountNotFollowing = userCountNotFollowing;
            return this;
        }

        public RegionRetailerDTOBuilder userIncreaseCountNotFollowing(Long userIncreaseCountNotFollowing) {
            this.userIncreaseCountNotFollowing = userIncreaseCountNotFollowing;
            return this;
        }

        public RegionRetailerDTOBuilder targetProgress(BigDecimal targetProgress) {
            this.targetProgress = targetProgress;
            return this;
        }

        public RegionRetailerDTOBuilder targetProgressStr(String targetProgressStr) {
            this.targetProgressStr = targetProgressStr;
            return this;
        }

        public RegionRetailerDTOBuilder inviteAccumulativeCount(Long inviteAccumulativeCount) {
            this.inviteAccumulativeCount = inviteAccumulativeCount;
            return this;
        }

        public RegionRetailerDTOBuilder inviteSingleMonthCount(Long inviteSingleMonthCount) {
            this.inviteSingleMonthCount = inviteSingleMonthCount;
            return this;
        }

        public RegionRetailerDTOBuilder phwdAccumulativeCount(Long phwdAccumulativeCount) {
            this.phwdAccumulativeCount = phwdAccumulativeCount;
            return this;
        }

        public RegionRetailerDTOBuilder phwdSingleMonthCount(Long phwdSingleMonthCount) {
            this.phwdSingleMonthCount = phwdSingleMonthCount;
            return this;
        }

        public RegionRetailerDTOBuilder selfDisciplineAccumulativeCount(Long selfDisciplineAccumulativeCount) {
            this.selfDisciplineAccumulativeCount = selfDisciplineAccumulativeCount;
            return this;
        }

        public RegionRetailerDTOBuilder selfDisciplineSingleMonthCount(Long selfDisciplineSingleMonthCount) {
            this.selfDisciplineSingleMonthCount = selfDisciplineSingleMonthCount;
            return this;
        }

        public RegionRetailerDTOBuilder leagueAccumulativeCount(Long leagueAccumulativeCount) {
            this.leagueAccumulativeCount = leagueAccumulativeCount;
            return this;
        }

        public RegionRetailerDTOBuilder leagueSingleMonthCount(Long leagueSingleMonthCount) {
            this.leagueSingleMonthCount = leagueSingleMonthCount;
            return this;
        }

        public RegionRetailerDTOBuilder getCustomersAccumulativeCount(Long getCustomersAccumulativeCount) {
            this.getCustomersAccumulativeCount = getCustomersAccumulativeCount;
            return this;
        }

        public RegionRetailerDTOBuilder getCustomersSingleMonthCount(Long getCustomersSingleMonthCount) {
            this.getCustomersSingleMonthCount = getCustomersSingleMonthCount;
            return this;
        }

        public RegionRetailerDTOBuilder scanCodeAccumulativeCount(Long scanCodeAccumulativeCount) {
            this.scanCodeAccumulativeCount = scanCodeAccumulativeCount;
            return this;
        }

        public RegionRetailerDTOBuilder scanCodeSingleMonthCount(Long scanCodeSingleMonthCount) {
            this.scanCodeSingleMonthCount = scanCodeSingleMonthCount;
            return this;
        }

        public RegionRetailerDTOBuilder othersAccumulativeCount(Long othersAccumulativeCount) {
            this.othersAccumulativeCount = othersAccumulativeCount;
            return this;
        }

        public RegionRetailerDTOBuilder othersSingleMonthCount(Long othersSingleMonthCount) {
            this.othersSingleMonthCount = othersSingleMonthCount;
            return this;
        }

        public RegionRetailerDTO build() {
            return new RegionRetailerDTO(this.provinceRetailerList, this.regionName, this.userCountNotFollowingTarget, this.userIncreaseCountNotFollowingTarget, this.userCount, this.userCountNotFollowing, this.userIncreaseCountNotFollowing, this.targetProgress, this.targetProgressStr, this.inviteAccumulativeCount, this.inviteSingleMonthCount, this.phwdAccumulativeCount, this.phwdSingleMonthCount, this.selfDisciplineAccumulativeCount, this.selfDisciplineSingleMonthCount, this.leagueAccumulativeCount, this.leagueSingleMonthCount, this.getCustomersAccumulativeCount, this.getCustomersSingleMonthCount, this.scanCodeAccumulativeCount, this.scanCodeSingleMonthCount, this.othersAccumulativeCount, this.othersSingleMonthCount);
        }

        public String toString() {
            return "RegionRetailerDTO.RegionRetailerDTOBuilder(provinceRetailerList=" + this.provinceRetailerList + ", regionName=" + this.regionName + ", userCountNotFollowingTarget=" + this.userCountNotFollowingTarget + ", userIncreaseCountNotFollowingTarget=" + this.userIncreaseCountNotFollowingTarget + ", userCount=" + this.userCount + ", userCountNotFollowing=" + this.userCountNotFollowing + ", userIncreaseCountNotFollowing=" + this.userIncreaseCountNotFollowing + ", targetProgress=" + this.targetProgress + ", targetProgressStr=" + this.targetProgressStr + ", inviteAccumulativeCount=" + this.inviteAccumulativeCount + ", inviteSingleMonthCount=" + this.inviteSingleMonthCount + ", phwdAccumulativeCount=" + this.phwdAccumulativeCount + ", phwdSingleMonthCount=" + this.phwdSingleMonthCount + ", selfDisciplineAccumulativeCount=" + this.selfDisciplineAccumulativeCount + ", selfDisciplineSingleMonthCount=" + this.selfDisciplineSingleMonthCount + ", leagueAccumulativeCount=" + this.leagueAccumulativeCount + ", leagueSingleMonthCount=" + this.leagueSingleMonthCount + ", getCustomersAccumulativeCount=" + this.getCustomersAccumulativeCount + ", getCustomersSingleMonthCount=" + this.getCustomersSingleMonthCount + ", scanCodeAccumulativeCount=" + this.scanCodeAccumulativeCount + ", scanCodeSingleMonthCount=" + this.scanCodeSingleMonthCount + ", othersAccumulativeCount=" + this.othersAccumulativeCount + ", othersSingleMonthCount=" + this.othersSingleMonthCount + ")";
        }
    }
}

