package cn.com.duiba.cloud.manage.service.api.model.param.report;

import java.io.Serializable;
import java.util.Date;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * @author xuanhongjian
 */
@Data
public class ExportReportParam implements Serializable {

    private static final long serialVersionUID = 1102718850533441228L;
    /**
     * 开始时间
     */
    @NotNull(message = "开始时间不能为空")
    private Date startDate;
    /**
     * 结束时间
     */
    @NotNull(message = "结束时间不能为空")
    private Date endDate;

    /**
     * 活动归属
     */
    private String activityBelong;

    /**
     * 需求来源
     */
    private String source;

    /**
     * 租户ID
     */
    private Long tenantId;

    /**
     * 登录用户id
     */
    private Long innerUserId;
}
