package cn.com.duiba.cloud.manage.service.api.remoteservice.report;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.WeChatReptileDataDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.report.InsertDataForReptileParam;
import cn.com.duiba.cloud.manage.service.api.model.param.report.ReptileDataParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * @author xuanhongjian
 */
@AdvancedFeignClient
public interface RemoteInsertDataService {

    /**
     * python 数据入库
     *
     * @param param 数据入库
     * @return 是否成功
     * @throws BizException 业务异常
     */
    Boolean insertDataForReptile(InsertDataForReptileParam param) throws BizException;



    /**
     * 分页获取数据
     * @param reptileDataParam
     * @return
     */
    PageResponse<WeChatReptileDataDTO> query(ReptileDataParam reptileDataParam) throws BizException;
}