package cn.com.duiba.cloud.manage.service.api.model.dto.plan.approval;

import lombok.Data;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * @author nongfu
 * @Date 2022/11/4 17:04
 */
@Data
public class RemoteApprovalDetailDto implements Serializable {

    /**
     * 审批单名称
     */
    private String approvalSheetName;
    /**
     * 审批编号
     */
    private Long approvalSheetNo;

    /**
     * 发起人
     */
    private String creatName;
    /**
     * 部门名称
     */
    private String departmentName;
    /**
     * 1:待发起 2:审批中 3:审批通过 4:审批失败'
     */
    private  Integer checkStatus;
    /**
     * 审批单详情json
     */
    private  String reasonJson;

    /**
     * 流程数据
     */
    private List<RemoteApprovalProcessDto> approvalProcessVoList = Collections.emptyList();

    /**
     * 当前进度节点id
     */
    private  Integer approvalProcessId;
    /**
     * 审批按钮状态
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.plan.ApprovalButtonEnum
     */
    private  Integer button  = 1;
    /**
     * 1 需要签字  0 复用  2无需签名
     */
    private  Integer ifSign  = 2;

    /**
     * 签名图片
     */
    private String img;

    private Date gmtCreate;

}
