package cn.com.duiba.cloud.manage.service.api.model.dto.report.export;

import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;


/**
 * @Description 年度计划导出
 * @Date 2022/9/16 16:51
 * @Author LuHui
 */
@Data
public class ExportYearPlanData {

    /**
     * 日期
     */
    @ExcelProperty("运营项目")
    private String templateName;

    /**
     * 活动名称
     */
    @ExcelProperty("活动描述")
    private String activityName;
    /**
     * 活动时间
     */
    @ExcelProperty("活动时间")
    private String activityTime;
    /**
     * 活动品规
     */
    @ExcelProperty("活动品规")
    private String regulate;
    /**
     * 部门
     */
    @ExcelProperty("业务单元")
    private String department;
    /**
     * 活动负责人
     */
    @ExcelProperty("活动负责人")
    private String dutyPerson;

    /**
     * 零售户入网数
     */
    @ExcelProperty("KPI入网零售户数（万户）")
    private String saleAccessNum;
    /**
     * 消费者获客
     */
    @ExcelProperty("KPI客户联接数（万人）")
    private String consumerAcquireNum;
    /**
     * 零售户活动交互
     */
    @ExcelProperty("零售户活动交互(万户次)")
    private String saleJoinNum;
    /**
     * 消费者活动交互
     */
    @ExcelProperty("消费者活动交互(万人次)")
    private String consumerJoinNum;
    /**
     * 推文宣传交互
     */
    @ExcelProperty("推文宣传交互(万人次)")
    private String tweetJoinNum;
    /**
     * 策划推广费用
     */
    @ExcelProperty("策划推广费用(万元)")
    private String planExtendCost;
    /**
     * 市场营销烟合计(万元)
     */
    @ExcelProperty("市场营销烟合计(万元)")
    private String marketCigarettesCost;
    /**
     * 市场营销烟合计(条)
     */
    @ExcelProperty("市场营销烟合计(条)")
    private String marketCigarettesTotal;
    /**
     * 营销物资合计
     */
    @ExcelProperty("营销物资合计(万元)")
    private String marketGoodNum;
    /**
     * 快递合计(单数)
     */
    @ExcelProperty("快递合计(单数)")
    private String expressTotal;
    /**
     * 快递合计(万元)
     */
    @ExcelProperty("快递合计(万元)")
    private String expressCost;
    /**
     * 零售户交互人均单价
     */
    @ExcelProperty("零售户交互人均单价(元)")
    private String saleJoinAvg;
    /**
     * 消费者交互人均单价
     */
    @ExcelProperty("消费者交互人均单价(元)")
    private String consumerJoinAvg;
    /**
     * 推文交互人均单价
     */
    @ExcelProperty("推文交互人均单价(元)")
    private String tweetJoinAvg;
    /**
     * 零售户新增入网（万户）
     */
    @ExcelProperty("零售户新增入网（万户）")
    private String addSaleAccessNum;
    /**
     * 获客新增关注（万人）
     */
    @ExcelProperty(" 获客新增关注（万人）")
    private String newAttentionCustomer;
    /**
     * KPI运营交互量（万人次）
     */
    @ExcelProperty("KPI运营交互量（万人次）")
    private String kpiOperationInteraction;
}
