package cn.com.duiba.cloud.manage.service.api.model.enums;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/5/26 11:47
 */
@Getter
@AllArgsConstructor
public enum AssociateStateEnum implements IEnum<Integer> {

    /**
     * 0 未关联
     * 1 已关联
     */
    DISABLE(0, "未关联"),
    ENABLE(1, "已关联");

    private final Integer code;
    private final String desc;

    @Override
    public Integer getDbCode() {
        return code;
    }
}
