package cn.com.duiba.cloud.manage.service.api.model.param.terminal;

import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/7/4 13:59
 **/
@Getter
@Setter
public class RemoteTerminalReportRecordSaveParam implements Serializable {

    /**
     * 活动id
     */
    @NotNull(message = "活动id不能为空")
    private Long activityId;

    /**
     * 终端业务员id
     */
    @NotNull(message = "终端业务员id不能为空")
    private Long terminalId;

    /**
     * 零售户id list
     */
    @NotEmpty(message = "零售户id不能为空")
    private List<Long> retailerIdList;

    /**
     * 是否发放物资，0 不发放，1 发放
     */
    private Integer distribute;

    /**
     * 是否有参与资格，0 没有参与资格，1 有参与资格
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.terminal.QualificationEnum
     */
    private Integer state;

    /**
     * 审核状态
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.audit.AuditStateEnum
     */
    private Integer auditState;
}
