package cn.com.duiba.cloud.manage.service.api.model.param.exportrecord;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.List;


@Data
@EqualsAndHashCode(callSuper=false)
public class RemoteExportConsumerRequest extends RemoteExportRecordRequest implements Serializable {


    /**
     * union id
     */
    private String unionId;

    /**
     * 开放id
     */
    private String openId;

    /**
     * 标签id
     */
    private List<Long> tagIds;
    /**
     * 用户类型
     */
    private Integer userType;
    /**
     * 昵称
     */
    private String nickname;

    /**
     * 电话号码
     */
    private String phone;
    /**
     * 省
     */
    private String province;
    /**
     * 城市
     */
    private String city;
    /**
     * 国家
     */
    private String country;
    /**
     * 注册开始时间
     */
    private Date registerStartTime;

    /**
     * 注册结束时间
     */
    private Date registerEndTime;

    /**
     * 订阅状态
     */
    private Integer subscribeStatus;

    /**
     * 是否返回数量
     */
    private Boolean isCount;


    /**
     * 新标签id列表
     */
    private List<Long> tagValueIdList;

    /**
     * 关联情况 0：全部 1：已关联 2：未关联
     */
    private Integer tagConnect;


    /**
     * 标签用户群id
     */
    private Long tagUserGroupId;


    /**
     * 当前页码。从1开始计数
     */
    private int pageNo;

    /**
     * 每页记录数
     */
    private int pageSize;

    /**
     * 文件名
     */
    private String fileName;
}


