package cn.com.duiba.cloud.manage.service.api.remoteservice.activityReport;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.PointRemainReportDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.RetentionDto;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.UserViewReportDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.signActivity.JoinReportDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.signActivity.PrizeReportDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.travel.TravelPrizeReportDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.travel.TravelTaskDTO;
import org.w3c.dom.stylesheets.LinkStyle;

import java.util.List;

/**
 * @author: LuHui
 * @Date: 2022/10/13 13:46
 * @Description: 旅行的选择活动数据报表
 */
@AdvancedFeignClient
public interface RemoteTravelActDataReportService {


    /**
     * 平和星余额报表数据
     *
     * @param activityId 活动id
     * @return
     */
    PointRemainReportDTO pointRemainReport(Long activityId);

    /**
     * 手动统计平和星余额
     *
     * @param day
     * @param hour
     * @throws Exception
     */
    void testPointRemainReport(String day, Integer hour) throws Exception;

    /**
     * 查询留存率报表
     *
     * @param activityId
     * @return
     */
    List<RetentionDto> queryRetentionReport(Long activityId);

    /**
     * 手动统计留存率
     *
     * @param day
     * @param hour
     */
    void testRetentionReport(String day, Integer hour) throws Exception;

    /**
     * 查询时段
     *
     * @param activityId
     * @return
     */
    UserViewReportDTO queryTimeReport(Long activityId);

    /**
     * 查询奖品
     *
     * @param activityId
     * @return
     */
    TravelPrizeReportDTO queryPrizeReport(Long activityId);

    /**
     * 查询任务
     *
     * @param activityId
     * @return
     */
    TravelTaskDTO queryTaskReport(Long activityId);

    /**
     * 查询参与
     *
     * @param activityId
     * @return
     */
    JoinReportDTO queryJoinReport(Long activityId) throws BizException;


    void testData(Integer day, Integer type) throws BizException;

    void testUserViewReport(String day,Integer hour) throws Exception;


}
