package cn.com.duiba.cloud.manage.service.api.remoteservice.plan.approval;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.plan.approval.RemoteApprovalFlowInfoDto;
import cn.com.duiba.cloud.manage.service.api.model.dto.plan.approval.RemoteApprovalStreamDetailDto;
import cn.com.duiba.cloud.manage.service.api.model.dto.plan.approval.RemoteApprovalStreamDto;
import cn.com.duiba.cloud.manage.service.api.model.param.plan.approval.RemoteApprovalParam;
import cn.com.duiba.cloud.manage.service.api.model.param.plan.approval.RemoteApprovalStateParam;
import cn.com.duiba.cloud.manage.service.api.model.param.plan.approval.RemoteUpdateApprovalStreamParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * @Author: nongfu
 * @Date: 2022/11/8-11:05
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteApprovalStreamService {

    /**
     * 审批流列表
     *
     * @param param
     * @return
     * @throws Exception
     */
    PageResponse<RemoteApprovalStreamDto> queryList(RemoteApprovalParam param);

    /**
     * 停用 /启用
     *
     * @param param
     * @return
     * @throws Exception
     */
    Boolean changeState(RemoteApprovalStateParam param) throws BizException;

    /**
     * 编辑审批流
     *
     * @param param
     * @return
     * @throws Exception
     */
    Boolean updateApproval(RemoteUpdateApprovalStreamParam param) throws BizException;

    /**
     * 查看审批流
     *
     * @return
     * @throws Exception
     */
    RemoteApprovalStreamDetailDto detail(Long id) throws BizException;

    /**
     * 查询所有审批流
     * @return
     */
    List<RemoteApprovalFlowInfoDto> queryAllApprovalFlow();


}
