package cn.com.duiba.cloud.manage.service.api.model.dto.tenant;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @description
 * @date 2021/11/5 11:51
 */
@Getter
@Setter
@ToString
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class TenantDTO implements Serializable {

    private static final long serialVersionUID = -4793101041305969918L;
    /**
     * 企业id
     */
    private Long tenantId;

    /**
     * 企业名称
     */
    private String name;

    /**
     * 首字母
     */
    private String firstLetter;

    /**
     * 部门信息
     */
    private List<DeptInfoDTO> departmentInfoList;

    /**
     * 身份标识，1 管理员，2 普通用户
     */
    private Integer identify;

    /**
     * 员工id
     */
    private Long staffId;
}
