package cn.com.duiba.cloud.manage.service.api.remoteservice.common;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.param.common.RemoteCaptchaParam;
import cn.com.duiba.cloud.manage.service.api.model.param.common.RemoteGetCodeParam;
import cn.hutool.captcha.LineCaptcha;

/**
 * @author yuanzhixin
 * @version 1.0
 * @description 通用服务
 * @date 2021/11/19 11:13
 */
@AdvancedFeignClient
public interface RemoteCommonService {

    /**
     * 获取图片验证码
     * @param param 查询参数
     * @return 验证码数值
     * @throws BizException e
     */
    LineCaptcha getCode(RemoteGetCodeParam param) throws BizException;

    /**
     * 校验图片验证码
     * @param param 验证码
     * @return true 表示通过
     * @throws BizException e
     */
    Boolean verifyCode(RemoteCaptchaParam param) throws BizException;
}
