package cn.com.duiba.cloud.manage.service.api.remoteservice.replay;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.replay.ReplayDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.replay.ReplayTemplateDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.replay.RemoteCreateReplayParam;
import cn.com.duiba.cloud.manage.service.api.model.param.replay.RemoteEditReplayParam;
import cn.com.duiba.cloud.manage.service.api.model.param.replay.RemoteQueryReplayListParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * @author xuanyu
 * @description:
 * @date 2022/10/18 3:44 PM
 */
@AdvancedFeignClient
public interface RemoteReplyService {
    /**
     * 查询复盘模板列表
     * @param pageNo 页码
     * @param pageSize 查询条数
     * @return
     */
    PageResponse<ReplayTemplateDTO> replayTemplateList(Integer pageNo, Integer pageSize);

    /**
     * 创建复盘
     * @param remoteCreateReplayParam
     * @return
     */
    Long createReplay(RemoteCreateReplayParam remoteCreateReplayParam);

    /**
     * 编辑复盘
     * @param remoteEditReplayParam
     */
    void editReplay(RemoteEditReplayParam remoteEditReplayParam);

    /**
     * 删除复盘
     * @param replayId 复盘id
     */
    void deleteReplay(Long replayId);

    /**
     * 根据复盘配置id查询
     * @param replayId
     * @return
     */
    ReplayDTO getReplayById(Long replayId);

    /**
     *
     * @param remoteQueryReplayListParam
     * @return
     */
    PageResponse<ReplayDTO> listReplay(RemoteQueryReplayListParam remoteQueryReplayListParam);
}
