package cn.com.duiba.cloud.manage.service.api.remoteservice.supplier;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.supplier.DeliGetDeliveryInfoDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.supplier.DeliGetGoodsInfoBySkuDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.supplier.DeliGetLogisticsInfoDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.supplier.DeliGetOrderStateDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.supplier.RemoteDeliConfirmReceiptParam;
import cn.com.duiba.cloud.manage.service.api.model.param.supplier.RemoteDeliGetDeliveryInfoParam;
import cn.com.duiba.cloud.manage.service.api.model.param.supplier.RemoteDeliGetGoodsInfoBySkuParam;
import cn.com.duiba.cloud.manage.service.api.model.param.supplier.RemoteDeliGetLogisticsInfoParam;
import cn.com.duiba.cloud.manage.service.api.model.param.supplier.RemoteDeliGetOrderStateParam;
import cn.com.duiba.cloud.manage.service.api.model.param.supplier.RemoteDeliOrderSubmitParam;

/**
 * 得力供应商服务
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/1/28
 */
@AdvancedFeignClient
public interface RemoteDeliSupplierService {

    /**
     * 根据sku获取商品信息
     *
     * @param remoteParam
     * @return
     * @throws BizException
     */
    DeliGetGoodsInfoBySkuDTO getGoodsInfoBySku(RemoteDeliGetGoodsInfoBySkuParam remoteParam) throws BizException;

    /**
     * 采购订单提交
     *
     * @param remoteParam
     * @throws BizException
     */
    void orderSubmit(RemoteDeliOrderSubmitParam remoteParam) throws BizException;

    /**
     * 查询订单状态 - 如果查无此订单会返回null
     *
     * @param remoteParam
     * @return
     * @throws BizException
     */
    DeliGetOrderStateDTO getOrderState(RemoteDeliGetOrderStateParam remoteParam) throws BizException;

    /**
     * 获取订单发货信息接口 - 请勿调用
     *
     * @param remoteParam
     * @return
     * @throws BizException
     */
    @Deprecated
    DeliGetDeliveryInfoDTO getDeliveryInfo(RemoteDeliGetDeliveryInfoParam remoteParam) throws BizException;

    /**
     * 订单确认收货
     *
     * @param remoteParam
     * @throws BizException
     */
    void confirmReceipt(RemoteDeliConfirmReceiptParam remoteParam) throws BizException;

    /**
     * 查询订单物流信息
     *
     * @param remoteParam
     * @return
     * @throws BizException
     */
    DeliGetLogisticsInfoDTO getLogisticsInfo(RemoteDeliGetLogisticsInfoParam remoteParam) throws BizException;
}
