package cn.com.duiba.cloud.manage.service.api.interceptor;

import cn.com.duiba.cloud.manage.service.api.annotation.DataSecretAnnotation;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;

/**
 * @program: duiba-manage-service
 * @description: 数据加密类拦截器
 * 拦截所有的Controller类是否需要拦截缩小返回字段的判断数量
 * @author: 郭云龙
 * @create: 2021-11-25 16:04
 **/

@Component
public class DataSecretClassInterceptor implements HandlerInterceptor {

    //标记名称
    public static final String DATA_SECRET_ANNOTATION = "DATA_SECRET_ANNOTATION";

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler)
            throws Exception {
        if (handler instanceof HandlerMethod) {
            final HandlerMethod handlerMethod = (HandlerMethod) handler;
            final Class<?> clazz = handlerMethod.getBeanType();
            final Method method = handlerMethod.getMethod();
            // 判断是否在类对象上添加了注解
            if (clazz.isAnnotationPresent(DataSecretAnnotation.class)) {
                // 设置此请求的数据加密保护，需要包装，往下传递，在DataSecretHandler接口进行判断
                request.setAttribute(DATA_SECRET_ANNOTATION, clazz.getAnnotation(DataSecretAnnotation.class));
                //判断是否在方法上添加了注解
            } else if (method.isAnnotationPresent(DataSecretAnnotation.class)) {
                request.setAttribute(DATA_SECRET_ANNOTATION, method.getAnnotation(DataSecretAnnotation.class));
            }
        }
        return true;
    }

}
