package cn.com.duiba.cloud.manage.service.api.model.dto.upcoming;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 推文月度计划
 * @TableName tb_tweets_plan
 */
@Data
public class TweetsPlanDTO implements Serializable {

    private static final long serialVersionUID = 3430975616816325552L;
    /**
     * 推文月度计划记录id
     */
    private Long id;

    /**
     * 关联待办id
     */
    private Long upcomingId;

    /**
     * 关联计划id
     */
    private Long operatePlanId;

    /**
     * 标题
     */
    private String title;

    /**
     * 推送开始时间
     */
    private Date pushStartTime;

    /**
     * 推送结束时间
     */
    private Date pushEndTime;

    /**
     * 推文顺序
     */
    private Integer pushOrder;

    /**
     * 主题内容
     */
    private String mainContent;

    /**
     * 形式
     */
    private String form;

    /**
     * 活动物料
     */
    private String activeMaterial;

    /**
     * 目标阅读量
     */
    private BigDecimal targetReading;

    /**
     * 创建日期
     */
    private Date gmtCreate;

    /**
     * 修改日期
     */
    private Date gmtModified;
}