package cn.com.duiba.cloud.manage.service.api.model.enums.plan;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * @Description 审批单业务需求负责人
 * @Date 2022/11/4 16:41
 * @Author LuHui
 */
public enum ApprovalBusinessDutyEnum {
    DUTY_ONE(1, "测试选项1"),
    DUTY_TWO(2, "测试选项2"),
    ;

    private Integer id;

    private String name;

    ApprovalBusinessDutyEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Integer getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public static ApprovalBusinessDutyEnum getById(Integer id){
        if (Objects.isNull(id)){
            return null;
        }
        return Stream.of(ApprovalBusinessDutyEnum.values()).filter(x -> Objects.equals(x.getId(), id)).findFirst().orElse(null);
    }
}
