package cn.com.duiba.cloud.manage.service.api.model.enums.plan;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * @Description 审批流类型
 * @Date 2022/11/9 13:38
 * @Author LuHui
 */
public enum ApprovalFlowTypeEnum {
    ACTIVITY_PLAN(1, "活动方案"),
    GOOD_APPROVAL(2, "物资审批"),
    ACTIVITY_DEVELOP(3, "活动开发"),
    TWEET(4, "推文"),
    ACTIVITY_PUBLISH(5, "活动发布"),
    LIVE(6, "直播"),
    TEMPLATE_MSG(7, "模版消息"),
    REQUIREMENT_SUBMISSION(8, "营销运营需求提报"),


    ;


    private Integer code;

    private String desc;

    ApprovalFlowTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static ApprovalFlowTypeEnum getByType(Integer type){
        if (Objects.isNull(type)){
            return null;
        }
        return Stream.of(ApprovalFlowTypeEnum.values()).filter(x -> Objects.equals(x.getCode(), type)).findFirst().orElse(null);
    }
}
