package cn.com.duiba.cloud.manage.service.api.model.enums.user;

import com.google.common.collect.ImmutableMap;

import java.util.Objects;

/**
 * 登录信息验证结果
 *
 * @author xuanhongjian
 */

public enum AccountStateEnum {
    /**
     * 登录信息验证
     */
    SUCCESS("成功", 1),
    PASSWORD_WRONG("密码错误", 2),
    USER_NOT_EXIST("用户不存在", 3),
    USER_EXIST("用户已存在", 4),
    PHONE_EXIST("手机号已经存在",5),
    OLD_PASSWORD_WRONG("原密码错误",6),
    UNKNOWN_STATE("未知状态", 7),
    ACCOUNT_IS_DISABLED("账号未启用", 8),
    ;


    private static final ImmutableMap<Integer, AccountStateEnum> INNER_MAP;

    static {
        ImmutableMap.Builder<Integer, AccountStateEnum> builder = ImmutableMap.builder();
        for (AccountStateEnum item : AccountStateEnum.values()) {
            builder = builder.put(item.code, item);
        }
        INNER_MAP = builder.build();
    }

    /**
     * 登录提示信息
     */
    private final String message;

    /**
     * 登录返回code
     */
    private final Integer code;

    AccountStateEnum(String message, Integer code) {
        this.message = message;
        this.code = code;
    }


    public static AccountStateEnum getByCode(Integer termValue) {
        return Objects.isNull(INNER_MAP.get(termValue)) ? AccountStateEnum.UNKNOWN_STATE
                   : INNER_MAP.get(termValue);
    }

    public String getMessage() {
        return message;
    }

    public Integer getCode() {
        return code;
    }
}
