package cn.com.duiba.cloud.manage.service.api.model.param.supplier;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * 查询物流信息
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/3/18
 */
@Getter
@Setter
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class RemoteSuningLogisticsInfoParam implements Serializable {

    private static final long serialVersionUID = 8320234423388909356L;

    /**
     * 订单号
     */
    @NotBlank(message = "订单号不能为空")
    private String orderId;

    /**
     * 子订单信息
     */
    @NotEmpty(message = "子订单信息不能为空")
    private List<RemoteSuningOrderItemParam> orderItemIds;

}
