package cn.com.duiba.cloud.manage.service.api.remoteservice.risk;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.risk.*;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * @author: LuHui
 * @date: 2023/7/3 16:24
 * @description:
 */
@AdvancedFeignClient
public interface RemoteRiskService {

    /**
     * 上传待检测用户
     *
     * @param riskCheckDto
     */
    Boolean uploadWaitCheckUsers(RiskCheckDto riskCheckDto);

    /**
     * 根据订单号查询校验风控记录
     *
     * @param orderNum
     * @return
     */
    RiskRecordDto findRiskRecordByOrderNum(String orderNum);

    /**
     * 风控检测回调
     * @param riskCheckCallbackDto
     */
    void riskCheckCallback(RiskCheckCallbackDto riskCheckCallbackDto) throws BizException;

    /**
     * 模型训练接口回调
     *
     * @param riskCheckCallbackDto
     * @return
     */
    void callbackFromTrainingModel(RiskCheckCallbackDto riskCheckCallbackDto) throws BizException;


    /**
     * 上传训练数据
     */
    Boolean uploadTrainData(RiskCheckDto riskCheckDto);

    /**
     * 分页查询用户风险列表
     *
     * @return
     */
    PageResponse<RiskPageDto> pageRiskList(String openId, Integer pageNo, Integer pageSize);


    /**
     * 获取用户风险详情
     *
     * @param openId
     * @return
     */
    RiskDetailDto getRiskDetail(String openId);


    /**
     * 获取用户风险地区
     *
     * @param address
     * @return
     */

    RiskAreaDto getRiskArea(String address);

    /**
     * 导入风控数据
     * @param remoteImportRiskDto
     */
    void importRiskData(RemoteImportRiskDto remoteImportRiskDto);


}
