package cn.com.duiba.cloud.manage.service.api.model.dto.plan.approval;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Description 审批单列表页信息
 * @Date 2022/11/3 16:47
 * @Author LuHui
 */
@Data
public class RemoteApprovalPageInfoDto implements Serializable {

    private static final long serialVersionUID = -1742710378450619963L;
    /**
     * 审批单id 状态为待发起无id
     */
    private Long id;
    /**
     * 审批流id
     */
    private Long approvalFlowId;
    /**
     * 审批单名字
     */
    private String approvalSheetName;
    /**
     * 部门名称
     */
    private String departmentName;
    /**
     * 用户名称
     */
    private String username;
    /**
     * 发起时间 毫秒级时间戳
     */
    private Date gmtCreate;
    /**
     * 审批单状态 1:待发起 2:审批中 3:审批通过 4:审批失败
     */
    private Integer status;
    /**
     * 完成时间 毫秒级时间戳
     */
    private Date completeTime;
    /**
     * 角色类型 1:负责人 2:路人 3:审批人
     */
    private List<Integer> roleType;
    /**
     * 审批流是否启用 true:启用
     */
    private Boolean enable = false;
}
