package cn.com.duiba.cloud.manage.service.api.model.dto.tenant;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: LuHui
 * @date: 2023/11/30 19:07
 * @description:
 */
@Data
public class TenantStaffDto implements Serializable {

    private static final long serialVersionUID = 51401014595068147L;
    /**
     * 主键
     */
    private Long id;
    /**
     * 内部用户id
     */
    private Long innerUserId;
    /**
     * 用户id，可由企业设置，在当前企业下唯一
     */
    private String userId;
    /**
     * 企业id
     */
    private Long tenantId;
    /**
     * 员工名称
     */
    private String staffName;
    /**
     * 员工邮箱
     */
    private String email;
    /**
     * 备注
     */
    private String remark;
    /**
     * 状态 0-停用 1-启用
     */
    private Integer state;
    /**
     * 身份 0-企业管理员 1-普通用户
     */
    private Integer identify;
    /**
     * 岗位名称
     */
    private String positionName;
    /**
     * 创建时间
     */
    private Date gmtCreate;
    /**
     * 修改时间
     */
    private Date gmtModified;
    /**
     * 创建人
     */
    private Long createdBy;
    /**
     * 修改人
     */
    private Long modifiedBy;

    /**
     * 账号类型（1:外部账号，2：企业员工）
     */
    private Integer accountType;

    /**
     * 是否启用
     */
    private Integer isEnable;
    /**
     * 手机号
     */
    private String mobile;
}
