package cn.com.duiba.cloud.manage.service.api.model.param.sso;

import cn.com.duiba.cloud.manage.service.api.annotation.DataSecretFiledAnnotation;
import cn.com.duiba.cloud.manage.service.api.model.constant.RegexpConst;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import java.io.Serializable;

/**
 * 用户登录参数
 *
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class LoginParam implements Serializable {

    private static final long serialVersionUID = -2372224125142248454L;

    @NotBlank(message = "员工编号不能为空")
    private String userId;

    @DataSecretFiledAnnotation
    private String password;

    @NotBlank(message = "短信验证码不能为空")
    private String code;
}
