package cn.com.duiba.cloud.manage.service.api.remoteservice.system;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.system.UserLockDto;
import cn.com.duiba.cloud.manage.service.api.model.dto.system.UserLockInfoDto;
import cn.com.duiba.cloud.manage.service.api.model.param.system.RemoteUserLockPageParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * @author: LuHui
 * @date: 2023/11/29 14:35
 * @description:
 */
@AdvancedFeignClient
public interface RemoteUserLockService {

    Boolean insert(UserLockDto userLockDto);

    /**
     * 根据员工编号查询锁定用户
     * @param userId
     * @return
     */
    UserLockDto findByUserId(String userId);

    /**
     * 分页查询锁定用户
     * @param remoteUserLockPageParam
     * @return
     */
    PageResponse<UserLockInfoDto> pageUserLock(RemoteUserLockPageParam remoteUserLockPageParam);

    /**
     * 解锁用户,重置密码
     * @param id
     * @param password
     */
    void unLockUser(Long id, String password);

    /**
     * 查询锁定用户
     * @param id
     * @return
     */
    UserLockDto getById(Long id);
}
