package cn.com.duiba.cloud.manage.service.api.remoteservice.tenant;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.tenant.TenantInfoDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.tenant.TenantStaffDto;
import cn.com.duiba.cloud.manage.service.api.model.dto.tenant.UserIndexDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.tenant.UserInfoDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.BaseParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tenant.RemoteUserIndexParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tenant.RemoteUserInfoIndexParam;

/**
 * @author yuanzhixin
 * @version 1.0
 * @description
 * @date 2021/11/5 10:17
 */
@AdvancedFeignClient
public interface RemoteTenantService {

    /**
     * 企业首页信息
     * @param param 查询参数
     * @return UserIndexDTO
     * @throws BizException e
     */
    UserIndexDTO userIndex(RemoteUserIndexParam param) throws BizException;

    /**
     * 个人账号信息接口
     * @param param 查询参数
     * @return UserInfoDTO
     * @throws BizException e
     */
    UserInfoDTO userInfo(RemoteUserInfoIndexParam param) throws BizException;

    /**
     * 获取上次登录的企业id
     * @param baseParam 参数
     * @return 上次登录的企业id
     * @throws BizException e
     */
    Long getLastLoginTenantId(BaseParam baseParam) throws BizException;

    /**
     * 保存上次登录的企业id
     * @param baseParam 参数
     * @throws BizException e
     */
    void saveLastLoginTenantId(BaseParam baseParam) throws BizException;

    /**
     * 租户账号信息查询
     * @param param 查询参数
     * @return TenantInfoDTO
     * @throws BizException e
     */
    TenantInfoDTO tenantInfo(BaseParam param) throws BizException;

    /**
     * 租户账号信息查询
     * @param param 查询参数
     * @return TenantInfoDTO
     * @throws BizException e
     */
    TenantStaffDto getTenantInfo(BaseParam param) throws BizException;
}