package cn.com.duiba.cloud.manage.service.api.remoteservice.terminal;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.terminal.RetailerExecPageDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.terminal.RetailerProgressDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.terminal.TerminalStaffExecPageDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.terminal.RemoteAcquiringParam;
import cn.com.duiba.cloud.manage.service.api.model.param.terminal.RemoteAddressParam;
import cn.com.duiba.cloud.manage.service.api.model.param.terminal.RemoteApplySuppliesParam;
import cn.com.duiba.cloud.manage.service.api.model.param.terminal.RemoteAwardParam;
import cn.com.duiba.cloud.manage.service.api.model.param.terminal.RemoteAwardQueryParam;
import cn.com.duiba.cloud.manage.service.api.model.param.terminal.RemoteCompleteParam;
import cn.com.duiba.cloud.manage.service.api.model.param.terminal.RemoteConfirmParam;
import cn.com.duiba.cloud.manage.service.api.model.param.terminal.RemoteOrderCodeTypeUpdateParam;
import cn.com.duiba.cloud.manage.service.api.model.param.terminal.RemoteReceivedParam;
import cn.com.duiba.cloud.manage.service.api.model.param.terminal.RemoteRetailerExecPageParam;
import cn.com.duiba.cloud.manage.service.api.model.param.terminal.RemoteRetailerProgressQueryParam;
import cn.com.duiba.cloud.manage.service.api.model.param.terminal.RemoteTerminalDistributeParam;
import cn.com.duiba.cloud.manage.service.api.model.param.terminal.RemoteTerminalStaffExecPageParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
* @author yuanzhixin
* @version 1.0
* @date 2022-05-26 10:38:19
*/
@AdvancedFeignClient
public interface RemoteRetailerProgressService {

    /**
     * 执行管理-终端业务员管理分页查询
     * @param param 查询参数
     * @return 分页结果
     * @throws BizException 查询异常
     */
    PageResponse<TerminalStaffExecPageDTO> terminalPage(RemoteTerminalStaffExecPageParam param) throws BizException;

    /**
     * 执行管理-零售户分页查询
     * @param param 查询参数
     * @return 分页结果
     * @throws BizException 查询异常
     */
    PageResponse<RetailerExecPageDTO> retailerPage(RemoteRetailerExecPageParam param) throws BizException;

    /**
     * 统计获客数量
     * @param param 查询参数
     * @return 获客数量
     */
    Long countAwardNum(RemoteAwardQueryParam param);

    /**
     * 业务员发放物资
     * @param param 参数
     * @return 操作是否成功
     */
    boolean distribute(RemoteTerminalDistributeParam param);

    /**
     * 根据条件查询零售户进度情况
     * @param param 查询参数
     * @return RetailerProgressDTO
     */
    RetailerProgressDTO queryByParam(RemoteRetailerProgressQueryParam param);

    /**
     * 申请物资
     * @param param 请求参数
     * @return 操作是否成功
     */
    boolean applySupplies(RemoteApplySuppliesParam param);

    /**
     * 确认收货
     * @param param 请求参数
     * @return 操作是否成功
     */
    boolean confirm(RemoteConfirmParam param);

    /**
     * 完成指标
     * @param param 请求参数
     * @return 操作是否成功
     */
    boolean complete(RemoteCompleteParam param);

    /**
     * 修改为获客中
     * @param param 请求参数
     * @return 操作是否成功
     */
    boolean updateAcquiring(RemoteAcquiringParam param);

    /**
     * 已收货
     * @param param 请求参数
     * @return 操作是否成功
     */
    boolean received(RemoteReceivedParam param);

    /**
     * 修改地址
     * @param param 请求参数
     * @return 操作是否成功
     */
    boolean updateAddress(RemoteAddressParam param);

    /**
     * 根据二维码id查询获客记录
     * @param qrcodeId 二维码id
     * @return RetailerProgressDTO
     */
    RetailerProgressDTO queryByQrcodeId(Long qrcodeId);

    /**
     * 继承之前二维码用户的绑定关系
     * @param retailerId 零售户id
     * @param qrcodeId 二维码id
     */
    void updateRetailerIdByQrcodeId(Long retailerId, Long qrcodeId);

    /**
     * 领取奖品
     * @param param 请求参数
     * @return 操作是否成功
     */
    boolean award(RemoteAwardParam param);

    /**
     * 更新订单号和类型
     * @param param 请求参数
     * @return 操作是否成功
     */
    boolean updateOrderCodeAndType(RemoteOrderCodeTypeUpdateParam param);

    /**
     * 查询零售户待领奖记录
     * @param retailerId
     * @param activityId
     * @return
     */
    Long countRetailerWaitAwardRecord(Long retailerId,Long activityId);

    void bindStatusUpdate(RemoteApplySuppliesParam remoteApplySuppliesParam);
}
