package cn.com.duiba.user.server.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.user.server.api.dto.geo.GeoAdministrativeDivisiondto;
import cn.com.duiba.user.server.api.dto.geo.IpAreaDto;

import java.util.List;
import java.util.Map;

/**
 * 功能描述：行政区域
 *
 * @Auther: xiaotian
 * @Date: 2021/12/1 15:39
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteGeoAdministrativeDivisionService {

    List<GeoAdministrativeDivisiondto> geoGetList(String adCode, int level);

    List<GeoAdministrativeDivisiondto> getAll();

    /**
     * 解析区划代码
     *
     * @param code 区划代码
     * @return 省 市 区 街道
     */
    String parseAddressCode(String code) throws BizException;

    /**
     * 通过code码查询地址信息
     *
     * @param adCode 广告代码
     * @return {@link List<GeoAdministrativeDivisiondto>}
     */
    List<GeoAdministrativeDivisiondto> findCodeLink(String adCode);


    /**
     * 查询IP归属地
     */
    IpAreaDto findIpInfo(String ip);

    /**
     * 通过code码查询地址信息
     * @param codeList
     * @return
     */
    Map<String,List<GeoAdministrativeDivisiondto>> findAddressByCodeList(List<String> codeList);

}
