package cn.com.duiba.user.server.api.request;


import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.user.server.api.dto.consumer.ConsumerCookieDTO;
import cn.com.duiba.user.server.api.dto.consumer.ConsumerDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


/**
 *
 * @author zouweixiang
 * @date 2021/11/24
 */
@Slf4j
@Component
public class RequestLocal implements ApplicationContextAware, InitializingBean {

	private ApplicationContext applicationContext;
	private static DuibaConsumerCookieClient duibaConsumerCookieClient;

	/**
	 * 登录请求，用于把用户信息放入cookie(包括wdata4、w_ts两个cookie)，调用此方法会顺便把用户信息放到ThreadLocal中，以便后续请求能获取到正确的用户信息
	 *
	 * @param consumerDto
	 * @return 设置到cookie中的用户信息
	 */
	public static void injectConsumerInfoIntoCookie(HttpServletResponse response, ConsumerDTO consumerDto) {
		// 设置登录信息到cookie
		ConsumerCookieDTO consumerCookieDto = duibaConsumerCookieClient.injectConsumerInfoIntoCookie(consumerDto, response);

		// 设置登录信息到 ThreadLocal
		setApiActivityContext(consumerCookieDto);
	}

	/**
	 * 登录请求，从cookie(包括wdata4、w_ts两个cookie)中获取用户信息，并把用户信息放到ThreadLocal中，以便后续请求能获取到正确的用户信息
	 */
	public static void setThreadLocally(HttpServletRequest request) throws BizException {
		//先尝试从cookie wdata4中获取用户信息
		ConsumerCookieDTO consumerFromWdata4 = duibaConsumerCookieClient.getConsumerCookieDto(request);

		// 设置登录信息到 ThreadLocal
		setApiActivityContext(consumerFromWdata4);
	}

	/**
	 * 设置登录信息到 ThreadLocal
	 * @param consumerCookieDto
	 */
	public static void setApiActivityContext(ConsumerCookieDTO consumerCookieDto){
		if (null != consumerCookieDto) {
			UserContext.UserInfo userInfo = new UserContext.UserInfo();
			userInfo.setCid(consumerCookieDto.getCid());
			userInfo.setUid(consumerCookieDto.getPartnerUserId());
			userInfo.setUnionId(consumerCookieDto.getUnionId());
			userInfo.setLoginTime(consumerCookieDto.getTime());
			userInfo.setType(consumerCookieDto.getType());
			UserContext.setUserContext(userInfo);
		}
	}

	@Override
	public void setApplicationContext(ApplicationContext applicationContext) {
		this.applicationContext = applicationContext;
	}

	@Override
	public void afterPropertiesSet() {
		KmsClient kmsClient = applicationContext.getBean(KmsClient.class);
		RequestLocal.duibaConsumerCookieClient = new DuibaConsumerCookieClient(kmsClient);
	}
}
