package cn.com.duiba.user.server.api.dto.consumer;

import cn.com.duiba.user.server.api.dto.tag.TagAggregationDTO;
import cn.com.duiba.user.server.api.dto.tag.TagDto;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;


/**
 * 用户信息
 *
 * @author zouweixiang
 * @date 2021/11/23
 */
@Data
public class ConsumerDTO implements Serializable {

	private static final long serialVersionUID = 1016312318810556074L;

    /**
     * 主键
     */
    private Long id;
    /**
     * 开发者端用户ID
     */
    private String partnerUserId;

    /**
     * 开放id
     */
    private String unionId;
    /**
     * 用户类型
     */
    private Integer userType;
    /**
     * 昵称
     */
    private String nickname;
    /**
     * 性别
     */
    private Integer sex;
    /**
     * 头像
     */
    private String avatar;
    /**
     * 电话号码
     */
    private String phone;
    /**
     * 省
     */
    private String province;
    /**
     * 城市
     */
    private String city;
    /**
     * 国家
     */
    private String country;

    /**
     * 标签dto
     */
    private List<TagDto> tagList;

    /**
     * 标签聚合列表
     */
    @Deprecated
    private List<TagAggregationDTO> tagAggregationList;

    /**
     * 标签值id list
     */
    private List<Long> tagConfig;

    /**
     * 客户群id
     */
    private List<Long> customerGroupConfigList;

    /**
     * 订阅
     */
    private Integer subscribe;

    /**
     * 订阅时间
     */
    private Date subscribeTime;

    /**
     * 退订时间
     */
    private Date unsubscribeTime;
    /**
     * json字段(属于扩展字段)
     */
    private String extra;
    /**
     * 创建时间
     */
    private Date gmtCreate;

}