package cn.com.duiba.user.server.api.param.consumer;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class GetAllDataWithPageParam implements Serializable {

    private static final long serialVersionUID = 844150057581753659L;

    private List<Long> ids;

    /**
     * 开发者端用户ID也就是unionid
     */
    private String partnerUserId;
    /**
     * 昵称
     */
    private String nickname;
    /**
     * 开放id
     */
    private String unionId;

    /**
     * 电话号码
     */
    private String phone;

    /**
     * 上次查询最大ID
     */
    private Long currentId;

    /**
     * 分页大小
     */
    private Long pageSize;

    /**
     * 用户类型
     */
    private Integer userType;

    /**
     * 省
     */
    private String province;
    /**
     * 城市
     */
    private String city;

    /**
     * 区
     */
    private String district;

    /**
     * 标签id列表
     */
    private List<Long> tagIds;

    /**
     * 注册开始时间
     */
    private Date registerStartTime;

    /**
     * 注册结束时间
     */
    private Date registerEndTime;

    /**
     * 订阅状态
     */
    private Integer subscribeStatus;

    /**
     * 客户群id
     */
    private Long customerGroupId;
}
