package cn.com.duiba.user.server.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.user.server.api.dto.consumer.*;
import cn.com.duiba.user.server.api.param.RemoteBaseIdParam;
import cn.com.duiba.user.server.api.param.consumer.*;
import cn.com.duiba.user.server.api.param.consumer.GetAllDataWithPageParam;
import cn.com.duiba.user.server.api.param.consumer.OpenIdsParam;
import cn.com.duiba.user.server.api.param.consumer.RemoteChangeConsumerParam;
import cn.com.duiba.user.server.api.param.consumer.RemoteConsumerListParam;
import cn.com.duiba.user.server.api.param.consumer.RemoteConsumerQueryParam;
import cn.com.duiba.user.server.api.param.consumer.RemoteConsumerUidParam;
import cn.com.duiba.user.server.api.param.consumer.RemotePushUserCountParam;
import cn.com.duiba.wolf.entity.JsonResult;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * 客户服务
 *
 * @author zouweixiang
 * @date 2021/11/29
 */
@AdvancedFeignClient
public interface RemoteConsumerService {


    /**
     * 根据uid查询用户
     *
     * @param remoteConsumerUidParam uid
     * @return {@link JsonResult<ConsumerDTO>}
     */
    ConsumerDTO findByUid(RemoteConsumerUidParam remoteConsumerUidParam);

    /**
     * 保存用户
     *
     * @param consumerDTO 消费者dto
     * @return {@link SaveConsumerResultDTO}
     */
    SaveConsumerResultDTO saveConsumer(ConsumerDTO consumerDTO);

    /**
     * 客户分页查询
     *
     * @param remoteConsumerListParam 分页参数
     * @return {@link PageResponse<ConsumerListPageDTO>}
     */
    PageResponse<ConsumerListPageDTO> findPageConsumer(RemoteConsumerListParam remoteConsumerListParam);


    ConsumerPageCountDTO findPageCount(RemoteConsumerListParam remoteConsumerListParam);

    /**
     * 根据用户id批量查询
     *
     * @param remoteBaseIdParam 用户id
     * @return {@link ConsumerListDTO}
     */
    ConsumerListDTO batchFindConsumer(RemoteBaseIdParam remoteBaseIdParam);


    List<ConsumerDTO>  batchFindConsumerNoTagAndGroup(List<Long> userIds);

    /**
     * 根据id查询当个客户
     *
     * @param remoteBaseIdParam 用户id
     * @return {@link JsonResult<ConsumerDTO>}
     */
    ConsumerDTO findOneConsumer(RemoteBaseIdParam remoteBaseIdParam);

    /**
     * 查询单个用户信息 不查用户标签 和用户群
     * @param remoteBaseIdParam
     * @return
     */
    ConsumerDTO findOneConsumerNoTagAndGroup(RemoteBaseIdParam remoteBaseIdParam);


    /**
     * 单表查获取
     *
     * @param remoteConsumerQueryParam 查询参数
     * @return {@link ConsumerListDTO}
     */
    ConsumerListDTO findConsumerList(RemoteConsumerQueryParam remoteConsumerQueryParam);

    /**
     * 分页获取所有符合查询条件的数据
     *
     * @param getAllDataWithPageParam 查询参数
     * @return 数据
     */
    List<ConsumerDTO> allDataFromPage(GetAllDataWithPageParam getAllDataWithPageParam);

    /**
     * 根据openid 获取用户
     *
     * @param param 参数
     * @return 用户信息
     */
    List<ConsumerDTO> getConsumersByOpenIds(OpenIdsParam param);

    /**
     * 根据手机号获取用户信息
     *
     * @param phoneList
     * @return
     */
    List<ConsumerDTO> getConsumersByPhoneList(List<String> phoneList);

    /**
     * 修改消费者信息
     * @param param
     * @return
     */
    Boolean changeConsumerById(RemoteChangeConsumerParam param);

    /**
     * 统计留存关注人数
     * @param partnerUserIdList 用户id list
     * @return 留存关注人数
     */
    Long countSubscribeNum(List<String> partnerUserIdList);

    /**
     * 根据openid 查询已关注用户
     *
     * @param param 参数
     * @return 用户信息
     */
    List<ConsumerDTO> getSubscribeConsumersByOpenIds(OpenIdsParam param);

    /**
     * 根据id list查询已关注用户
     *
     * @param idList 参数
     * @return 用户信息
     */
    List<ConsumerDTO> getSubscribeConsumersByIds(List<Long> idList);

    /**
     * 根据id list查询已关注用户数量
     *
     * @param idList 参数
     * @return 用户信息
     */
    Long getSubscribeNumByIds(List<Long> idList);

    /**
     * 根据昵称精确查询
     * @param nickName 微信昵称
     * @return List<ConsumerDTO>
     */
    List<ConsumerDTO> findByNickName(String nickName);

    /**
     * 统计推送用户人数
     * @param remotePushUserCountParam 查询参数
     * @return
     */
    Long countPushUser(RemotePushUserCountParam remotePushUserCountParam);

    /**
     * 根据用户信息查询用户id
     * res true 分页只查用户id  false 查询满足条件的用户
     * @param remoteConsumerQueryParam
     * @return
     */
    List<ConsumerDTO> findConsumerListNewByPage(RemoteConsumerQueryParam remoteConsumerQueryParam,Boolean res);

    /**
     * 只查用户信息的总数
     * @param remoteConsumerQueryParam
     * @return
     */
    Long findConsumerListNewByPageCount(RemoteConsumerQueryParam remoteConsumerQueryParam);
}
