/*
 * Decompiled with CFR 0.152.
 */
package com.uop.sdk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.uop.sdk.EncryptType;
import com.uop.sdk.FileItem;
import com.uop.sdk.FopApiException;
import com.uop.sdk.FopClient;
import com.uop.sdk.FopOauthEncrypt;
import com.uop.sdk.FopParser;
import com.uop.sdk.FopRequest;
import com.uop.sdk.FopResponse;
import com.uop.sdk.FopUploadRequest;
import com.uop.sdk.ResponseEncryptItem;
import com.uop.sdk.SignItem;
import com.uop.sdk.SignType;
import com.uop.sdk.internal.parser.json.FopObjectJsonParser;
import com.uop.sdk.internal.parser.xml.ObjectXmlParser;
import com.uop.sdk.internal.util.AESUtil;
import com.uop.sdk.internal.util.Base64;
import com.uop.sdk.internal.util.CertUtil;
import com.uop.sdk.internal.util.FopEncrypt;
import com.uop.sdk.internal.util.FopHashMap;
import com.uop.sdk.internal.util.FopLogger;
import com.uop.sdk.internal.util.FopSignature;
import com.uop.sdk.internal.util.FopUtils;
import com.uop.sdk.internal.util.FopWebUtils;
import com.uop.sdk.internal.util.RequestParametersHolder;
import com.uop.sdk.internal.util.SM2Util;
import com.uop.sdk.internal.util.SM4Utils;
import com.uop.sdk.internal.util.StreamUtil;
import com.uop.sdk.internal.util.StringUtils;
import com.uop.sdk.internal.util.WebUtils;
import com.uop.sdk.internal.util.json.JSONWriter;
import com.uop.sdk.uop.request.UopRequest;
import com.uop.sdk.uop.response.UopResponse;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class DefaultFopClient
implements FopClient {
    private String serverUrl;
    private String appId;
    private String privateKey;
    private String publicKey;
    private String prodCode;
    private String format = "json";
    private SignType signType = SignType.RSA2;
    private EncryptType encryptType = EncryptType.AES;
    private String encryptKey;
    private String fopPublicKey;
    private String charset = "UTF-8";
    private boolean isBodyEncrypt = false;
    private FopOauthEncrypt fopOauthEncrypt;
    private long oauthEncryptGetTime;
    private int connectTimeout = 3000;
    private int readTimeout = 15000;
    private String proxyHost;
    private int proxyPort;

    public DefaultFopClient(String appId, String privateKey, String fopPublicKey) {
        this.appId = appId;
        this.privateKey = privateKey;
        this.fopPublicKey = fopPublicKey;
        this.isBodyEncrypt = false;
    }

    public DefaultFopClient(String appId, String privateKeyPath, String fopPublicKeyPath, String password) {
        this.appId = appId;
        this.privateKey = CertUtil.getPriKeyStr(privateKeyPath, password);
        this.fopPublicKey = CertUtil.getPubKeyStr(fopPublicKeyPath);
        this.isBodyEncrypt = false;
    }

    public DefaultFopClient(String appId, String privateKey, String fopPublicKey, SignType signType) {
        this(appId, privateKey, fopPublicKey);
        this.signType = signType;
    }

    public DefaultFopClient(String appId, String privateKey, String fopPublicKey, SignType signType, boolean isBodyEncrypt) {
        this(appId, privateKey, fopPublicKey, signType);
        this.isBodyEncrypt = isBodyEncrypt;
    }

    public DefaultFopClient(String appId, String privateKey, String fopPublicKey, SignType signType, boolean isBodyEncrypt, EncryptType encryptType) {
        this(appId, privateKey, fopPublicKey, signType, isBodyEncrypt);
        this.encryptType = encryptType;
    }

    public DefaultFopClient(String appId, String privateKey, String fopPublicKey, SignType signType, boolean isBodyEncrypt, EncryptType encryptType, String encryptKey) {
        this(appId, privateKey, fopPublicKey, signType, isBodyEncrypt, encryptType);
        this.encryptKey = encryptKey;
    }

    public DefaultFopClient(String appId, String privateKey, String fopPublicKey, SignType signType, boolean isBodyEncrypt, EncryptType encryptType, String encryptKey, String format, String charset) {
        this(appId, privateKey, fopPublicKey, signType, isBodyEncrypt, encryptType, encryptKey);
        this.format = format;
        this.charset = charset;
    }

    public DefaultFopClient(String appId, String privateKey, String fopPublicKey, SignType signType, boolean isBodyEncrypt, EncryptType encryptType, String format, String charset) {
        this(appId, privateKey, fopPublicKey, signType, isBodyEncrypt, encryptType);
        this.format = format;
        this.charset = charset;
    }

    public static Builder builder(String appId, String privateKey, String fopPublicKey) {
        return new Builder(appId, privateKey, fopPublicKey);
    }

    @Override
    public <T extends FopResponse> T execute(FopRequest<T> request) throws FopApiException {
        return this.execute(request, null);
    }

    @Override
    public String uopExecute(UopRequest request) throws FopApiException {
        UopResponse response = this.execute(request);
        return response.getUopResponseBody();
    }

    @Override
    public <T extends FopResponse> T execute(FopRequest<T> request, String accessToken) throws FopApiException {
        return this.execute(request, accessToken, null);
    }

    @Override
    public <T extends FopResponse> T execute(FopRequest<T> request, String accessToken, String appAuthToken) throws FopApiException {
        FopParser<T> parser = null;
        parser = "xml".equals(this.format) ? new ObjectXmlParser<T>(request.getResponseClass()) : new FopObjectJsonParser<T>(request.getResponseClass());
        return this._execute(request, parser, accessToken, appAuthToken);
    }

    @Override
    public <T extends FopResponse> T pageExecute(FopRequest<T> request) throws FopApiException {
        return this.pageExecute(request, "POST");
    }

    @Override
    public <T extends FopResponse> T pageExecute(FopRequest<T> request, String httpMethod) throws FopApiException {
        RequestParametersHolder requestHolder = this.getRequestHolderWithSign(request, null, null);
        if (FopLogger.isBizDebugEnabled().booleanValue()) {
            FopLogger.logBizDebug(this.getRedirectUrl(requestHolder));
        }
        FopResponse rsp = null;
        try {
            Class<T> clazz = request.getResponseClass();
            rsp = (FopResponse)clazz.newInstance();
        }
        catch (InstantiationException e) {
            FopLogger.logBizError(e);
        }
        catch (IllegalAccessException e) {
            FopLogger.logBizError(e);
        }
        if ("GET".equalsIgnoreCase(httpMethod)) {
            rsp.setUopSdkBody(this.getRedirectUrl(requestHolder));
        } else {
            String baseUrl = this.getRequestUrl(requestHolder);
            rsp.setUopSdkBody(WebUtils.buildForm(baseUrl, requestHolder.getApplicationParams()));
        }
        return (T)rsp;
    }

    @Override
    public <T extends FopResponse> T sdkExecute(FopRequest<T> request) throws FopApiException {
        RequestParametersHolder requestHolder = this.getRequestHolderWithSign(request, null, null);
        if (FopLogger.isBizDebugEnabled().booleanValue()) {
            FopLogger.logBizDebug(this.getSdkParams(requestHolder));
        }
        FopResponse rsp = null;
        try {
            Class<T> clazz = request.getResponseClass();
            rsp = (FopResponse)clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            FopLogger.logBizError(e);
        }
        rsp.setUopSdkBody(this.getSdkParams(requestHolder));
        return (T)rsp;
    }

    @Override
    public <TR extends FopResponse, T extends FopRequest<TR>> TR parseAppSyncResult(Map<String, String> result, Class<T> requsetClazz) throws FopApiException {
        FopResponse tRsp;
        String rsp = result.get("result");
        try {
            FopRequest request = (FopRequest)requsetClazz.newInstance();
            Class responseClazz = request.getResponseClass();
            if (StringUtils.isEmpty(rsp)) {
                tRsp = (FopResponse)responseClazz.newInstance();
                tRsp.setUopCode("20000");
                tRsp.setBizCode("200000");
                tRsp.setBizMsg(result.get("memo"));
            } else {
                FopParser parser = null;
                parser = "xml".equals(this.format) ? new ObjectXmlParser(responseClazz) : new FopObjectJsonParser(responseClazz);
                tRsp = parser.parse(rsp);
                tRsp.setUopSdkBody(rsp);
                this.checkResponseSign(request, parser, rsp, tRsp.isUopSuccess());
                if (!tRsp.isUopSuccess()) {
                    FopLogger.logBizError(rsp);
                }
            }
        }
        catch (RuntimeException e) {
            FopLogger.logBizError(rsp);
            throw e;
        }
        catch (FopApiException | IllegalAccessException | InstantiationException e) {
            FopLogger.logBizError(rsp);
            throw new FopApiException(e);
        }
        return (TR)tRsp;
    }

    private <T extends FopResponse> RequestParametersHolder getRequestHolderWithSign(FopRequest<?> request, String accessToken, String appAuthToken) throws FopApiException {
        RequestParametersHolder requestHolder = new RequestParametersHolder();
        FopHashMap appParams = new FopHashMap((Map<? extends String, ? extends String>)request.getTextParams());
        try {
            if (request.getClass().getMethod("getUopRequestBody", new Class[0]) != null && StringUtils.isEmpty((String)appParams.get("uop_data")) && request.getBizModel() != null) {
                appParams.put("uop_data", new JSONWriter().write(request.getBizModel(), true));
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException e) {
            FopLogger.logBizError(e);
        }
        requestHolder.setApplicationParams(appParams);
        if (StringUtils.isEmpty(this.charset)) {
            this.charset = "UTF-8";
        }
        FopHashMap protocalMustParams = new FopHashMap();
        protocalMustParams.put("X-Uop-Api-Code", request.getApiMethodName());
        protocalMustParams.put("X-Uop-Version", request.getApiVersion());
        protocalMustParams.put("X-Uop-App-Id", this.appId);
        protocalMustParams.put("X-Uop-Sign-Type", (Object)this.signType);
        protocalMustParams.put("terminal_type", request.getTerminalType());
        protocalMustParams.put("terminal_info", request.getTerminalInfo());
        protocalMustParams.put("notify_url", request.getNotifyUrl());
        protocalMustParams.put("return_url", request.getReturnUrl());
        protocalMustParams.put("X-Uop-Charset", this.charset);
        if (request.getIsEncrypt()) {
            if (StringUtils.isEmpty(this.encryptKey)) {
                switch (this.encryptType) {
                    case AES: {
                        this.encryptKey = AESUtil.generateAesKey();
                        break;
                    }
                    case SM4: {
                        this.encryptKey = SM4Utils.generateSm4Key();
                        break;
                    }
                }
            }
            protocalMustParams.put("encrypt_type", (Object)this.encryptType);
            protocalMustParams.put("X-Uop-Encrypted-Key", FopSignature.rsaEncrypt(this.encryptKey, this.fopPublicKey, this.charset));
        }
        if (StringUtils.areNotEmpty(request.getSequenceNo())) {
            protocalMustParams.put("X-Uop-Unique-No", request.getSequenceNo());
        } else {
            String sequenceNoUUID = UUID.randomUUID().toString().replace("-", "");
            protocalMustParams.put("X-Uop-Unique-No", sequenceNoUUID);
            request.setSequenceNo(sequenceNoUUID);
        }
        Long timestamp = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("YYYYMMddHHmmssSSS");
        protocalMustParams.put("X-Uop-Timestamp", sdf.format(timestamp));
        protocalMustParams.put("X-Uop-Nonce", UUID.randomUUID().toString().replaceAll("-", "").toUpperCase());
        requestHolder.setProtocalMustParams(protocalMustParams);
        FopHashMap protocalOptParams = new FopHashMap();
        protocalOptParams.put("X-Uop-Format", this.format);
        protocalOptParams.put("X-Uop-Auth-Token", accessToken);
        protocalOptParams.put("prod_code", request.getProdCode());
        if (!StringUtils.isEmpty(appAuthToken)) {
            protocalOptParams.put("app_auth_token", appAuthToken);
        }
        requestHolder.setProtocalOptParams(protocalOptParams);
        requestHolder.setApplicationParams(appParams);
        if (null != this.signType) {
            String signContent = FopSignature.getSignatureContent(requestHolder);
            switch (this.signType) {
                case RSA2: {
                    protocalMustParams.put("X-Uop-Signature", FopSignature.rsaSign(signContent, this.privateKey, this.charset, this.signType));
                    break;
                }
                case SM2: {
                    protocalMustParams.put("X-Uop-Signature", SM2Util.sign(signContent, this.privateKey));
                    break;
                }
                default: {
                    protocalMustParams.put("X-Uop-Signature", "");
                    break;
                }
            }
        } else {
            protocalMustParams.put("X-Uop-Signature", "");
        }
        FopHashMap signMap = new FopHashMap((Map<? extends String, ? extends String>)FopSignature.getSortedMap(requestHolder));
        requestHolder.setApplicationParams(signMap);
        return requestHolder;
    }

    private String getRequestUrl(RequestParametersHolder requestHolder) throws FopApiException {
        StringBuffer urlSb = new StringBuffer(this.serverUrl);
        try {
            String sysMustQuery = WebUtils.buildQuery(requestHolder.getProtocalMustParams(), this.charset);
            String sysOptQuery = WebUtils.buildQuery(requestHolder.getProtocalOptParams(), this.charset);
            urlSb.append("?");
            urlSb.append(sysMustQuery);
            if (sysOptQuery != null & sysOptQuery.length() > 0) {
                urlSb.append("&");
                urlSb.append(sysOptQuery);
            }
        }
        catch (IOException e) {
            throw new FopApiException(e);
        }
        return urlSb.toString();
    }

    private String getRedirectUrl(RequestParametersHolder requestHolder) throws FopApiException {
        StringBuffer urlSb = new StringBuffer(this.serverUrl);
        try {
            Map<String, String> sortedMap = FopSignature.getSortedMap(requestHolder);
            String sortedQuery = WebUtils.buildQuery(sortedMap, this.charset);
            urlSb.append("?");
            urlSb.append(sortedQuery);
        }
        catch (IOException e) {
            throw new FopApiException(e);
        }
        return urlSb.toString();
    }

    private String getSdkParams(RequestParametersHolder requestHolder) throws FopApiException {
        StringBuffer urlSb = new StringBuffer();
        try {
            Map<String, String> sortedMap = FopSignature.getSortedMap(requestHolder);
            String sortedQuery = WebUtils.buildQuery(sortedMap, this.charset);
            urlSb.append(sortedQuery);
        }
        catch (IOException e) {
            throw new FopApiException(e);
        }
        return urlSb.toString();
    }

    private <T extends FopResponse> T _execute20201112bak(FopRequest<T> request, FopParser<T> parser, String authToken, String appAuthToken) throws FopApiException {
        Map<String, Object> rt = this.doPost(request, authToken, appAuthToken);
        if (rt == null) {
            return null;
        }
        FopResponse tRsp = null;
        JSONObject uopData = null;
        try {
            String responseBody = (String)rt.get("rsp");
            JSONObject jb = JSONObject.parseObject((String)responseBody);
            if ("notsu".equals(jb.remove((Object)"notsu"))) {
                if (jb.get((Object)"uop_code") != null && StringUtils.areNotEmpty((String)jb.get((Object)"uop_code"))) {
                    jb.remove((Object)"uop_data");
                    tRsp = (FopResponse)parser.parse(jb.toJSONString());
                    return (T)tRsp;
                }
                throw new FopApiException(jb.toJSONString());
            }
            uopData = (JSONObject)jb.get((Object)"uop_data");
            if (uopData != null) {
                JSONObject uopData2 = JSONObject.parseObject((String)uopData.toJSONString());
                jb.putAll((Map)uopData2);
            }
            String paramBody = jb.toJSONString();
            tRsp = (FopResponse)parser.parse(paramBody, "uop");
            String X_Uop_Signature = jb.getString("X_Uop_Signature");
            String uop_signContent = jb.getString("uop_signContent");
            jb.remove((Object)"uop_signContent");
            boolean rsaCheckContent = FopSignature.rsaCheck(uop_signContent, X_Uop_Signature, this.fopPublicKey, this.charset, this.signType);
            if (!rsaCheckContent) {
                throw new FopApiException("\u9a8c\u7b7e\u5931\u8d25!");
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (FopApiException e) {
            throw new FopApiException(e);
        }
        if (tRsp.isUopSuccess()) {
            // empty if block
        }
        return (T)tRsp;
    }

    private <T extends FopResponse> T _execute(FopRequest<T> request, FopParser<T> parser, String authToken, String appAuthToken) throws FopApiException {
        Map<String, Object> rt = this.uopDoPost(request, authToken, appAuthToken);
        if (rt == null) {
            return null;
        }
        FopResponse tRsp = null;
        try {
            String uopResponseBody = (String)rt.get("rsp");
            tRsp = (FopResponse)parser.parse(uopResponseBody, "uop");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (FopApiException e) {
            throw new FopApiException(e);
        }
        if (tRsp.isUopSuccess()) {
            // empty if block
        }
        return (T)tRsp;
    }

    public String getEncryptKey(String url, Map<String, String> params) {
        if (this.oauthEncryptGetTime >= System.currentTimeMillis() || null == this.fopOauthEncrypt) {
            this.fopOauthEncrypt = this.getFopOauthEncrypt(url, params);
            this.oauthEncryptGetTime = this.fopOauthEncrypt.getAesKeyExpiresIn() + System.currentTimeMillis();
        }
        return this.fopOauthEncrypt.getAesKey();
    }

    private FopOauthEncrypt getFopOauthEncrypt(String url, Map<String, String> params) {
        url = url.substring(0, url.indexOf("/", url.indexOf("//") + 2)) + "/getTokenAndAesKey/" + params.get("X-Uop-App-Id");
        params.put("X-Uop-Api-Code", "oauth.get.token");
        params.put("X-Uop-Version", "1.0.0");
        JSONObject bizConent = new JSONObject();
        bizConent.put("grantType", (Object)"client_credentials");
        bizConent.put("appSecret", (Object)this.appId);
        params.put("uop_data", bizConent.toJSONString());
        try {
            Map<String, String> signParams = FopSignature.getSortedMap(bizConent);
            String signContent = FopSignature.getSignContent(signParams);
            params.put("X-Uop-Signature", FopSignature.rsaSign(signContent, this.privateKey, this.charset, this.signType));
            String enctryptBody = FopWebUtils.doPost(url, params, this.isBodyEncrypt, this.encryptType, this.encryptKey, this.charset, this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort, this.privateKey, "");
            JSONObject jb = JSONObject.parseObject((String)enctryptBody);
            JSONObject biz = jb.getJSONObject("uop_data");
            FopOauthEncrypt fopOauthEncrypt = (FopOauthEncrypt)JSONObject.parseObject((String)jb.getString("uop_data"), FopOauthEncrypt.class);
            return fopOauthEncrypt;
        }
        catch (Exception e) {
            FopLogger.logCommError(e, url, params.get("X-Uop-App-Id"), "oauth.get.token", params);
            return null;
        }
    }

    private <T extends FopResponse> Map<String, Object> doPost(FopRequest<T> request, String accessToken, String appAuthToken) throws FopApiException {
        boolean apiIsBodyEncrypt = request.getIsEncrypt();
        HashMap<String, Object> result = new HashMap<String, Object>();
        RequestParametersHolder requestHolder = this.getRequestHolderWithSign(request, accessToken, appAuthToken);
        String rsp = null;
        try {
            if (request instanceof FopUploadRequest) {
                FopUploadRequest uRequest = (FopUploadRequest)request;
                Map<String, FileItem> fileParams = FopUtils.cleanupMap(uRequest.getFileParams());
                rsp = FopWebUtils.doPost(this.serverUrl, (Map<String, String>)requestHolder.getApplicationParams(), fileParams, apiIsBodyEncrypt, this.encryptType, this.charset, this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort, this.privateKey, request.getReqUrl());
            } else {
                FopHashMap appParams = requestHolder.getApplicationParams();
                rsp = FopWebUtils.doPost(this.serverUrl, (Map<String, String>)appParams, apiIsBodyEncrypt, this.encryptType, this.encryptKey, this.charset, this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort, this.privateKey, request.getReqUrl());
            }
        }
        catch (IOException e) {
            throw new FopApiException(e);
        }
        catch (JSONException e) {
            throw new FopApiException("json\u8f6c\u6362\u9519\u8bef\uff1a" + e.getMessage());
        }
        JSONObject jb = JSON.parseObject((String)rsp);
        result.put("rsp", rsp);
        result.put("textParams", requestHolder.getApplicationParams());
        result.put("protocalMustParams", requestHolder.getProtocalMustParams());
        result.put("protocalOptParams", requestHolder.getProtocalOptParams());
        result.put("url", this.serverUrl);
        return result;
    }

    private <T extends FopResponse> Map<String, Object> uopDoPost(FopRequest<T> request, String accessToken, String appAuthToken) throws FopApiException {
        boolean apiIsBodyEncrypt = request.getIsEncrypt();
        HashMap<String, Object> result = new HashMap<String, Object>();
        RequestParametersHolder requestHolder = this.getRequestHolderWithSign(request, accessToken, appAuthToken);
        String rsp = null;
        try {
            if (request instanceof FopUploadRequest) {
                FopUploadRequest uRequest = (FopUploadRequest)request;
                Map<String, FileItem> fileParams = FopUtils.cleanupMap(uRequest.getFileParams());
                rsp = FopWebUtils.doPost(this.serverUrl, (Map<String, String>)requestHolder.getApplicationParams(), fileParams, apiIsBodyEncrypt, this.encryptType, this.charset, this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort, this.privateKey, request.getReqUrl());
            } else {
                FopHashMap appParams = requestHolder.getApplicationParams();
                rsp = FopWebUtils.uopDoPost(this.serverUrl, appParams, apiIsBodyEncrypt, this.encryptType, this.encryptKey, this.charset, this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort, this.privateKey, request.getReqUrl(), this.fopPublicKey, this.signType);
            }
        }
        catch (IOException e) {
            throw new FopApiException(e);
        }
        catch (JSONException e) {
            throw new FopApiException("json\u8f6c\u6362\u9519\u8bef\uff1a" + e.getMessage());
        }
        result.put("rsp", rsp);
        return result;
    }

    private <T extends FopResponse> void checkResponseSign(FopRequest<T> request, FopParser<T> parser, String responseBody, boolean responseIsSucess) throws FopApiException {
        if (!StringUtils.isEmpty(this.fopPublicKey)) {
            boolean rsaCheckContent;
            SignItem signItem = parser.getSignItem(request, responseBody);
            if (signItem == null) {
                throw new FopApiException("sign check fail: Body is Empty!");
            }
            if (responseIsSucess && !StringUtils.isEmpty(signItem.getSign()) && !(rsaCheckContent = FopSignature.rsaCheck(signItem.getSignSourceDate(), signItem.getSign(), this.fopPublicKey, this.charset, this.signType))) {
                if (!StringUtils.isEmpty(signItem.getSignSourceDate())) {
                    boolean jsonCheck;
                    String srouceData = signItem.getSignSourceDate();
                    if (signItem.getSignSourceDate().contains("\\/")) {
                        srouceData = signItem.getSignSourceDate().replace("\\/", "/");
                    }
                    if (!(jsonCheck = FopSignature.rsaCheck(srouceData, signItem.getSign(), this.fopPublicKey, this.charset, this.signType))) {
                        throw new FopApiException("\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5bc6\u94a5\u662f\u5426\u6b63\u786e\uff0c\u8fd4\u56de\u62a5\u6587\u662f\u5426\u683c\u5f0f\u6b63\u786e\uff01");
                    }
                } else {
                    throw new FopApiException("\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5bc6\u94a5\u662f\u5426\u6b63\u786e\uff01");
                }
            }
        }
    }

    private <T extends FopResponse> ResponseEncryptItem encryptResponse(FopRequest<T> request, Map<String, Object> rt, FopParser<T> parser) throws FopApiException {
        JSONObject jsonMap;
        String responseBody = (String)rt.get("rsp");
        String realBody = null;
        JSONObject jsonBody = JSONObject.parseObject((String)responseBody);
        String params = request.getDecryptParams();
        if (StringUtils.areNotEmpty(params) && null != this.encryptType) {
            jsonMap = jsonBody.getJSONObject("uop_data");
            if (jsonMap != null && !jsonMap.isEmpty()) {
                String[] paramArry;
                for (String param : paramArry = params.split(",")) {
                    String encryVal = jsonMap.getString(param);
                    if (!StringUtils.areNotEmpty(encryVal)) continue;
                    String encryptContent = FopEncrypt.decryptContent(encryVal, this.encryptType.getValue(), this.encryptKey, this.charset);
                    jsonMap.put(param, (Object)encryptContent);
                }
            }
        } else {
            throw new FopApiException("API\u8bf7\u6c42\u8981\u6c42\u89e3\u5bc6\uff0c\u5219\u5fc5\u987b\u8bbe\u7f6e\u5bc6\u94a5\u548c\u5bc6\u94a5\u7c7b\u578b\uff1aencryptKey=" + this.encryptKey + ",encryptType=" + (Object)((Object)this.encryptType));
        }
        jsonBody.put("uop_data", (Object)JSONObject.toJSONString((Object)jsonMap));
        realBody = JSONObject.toJSONString((Object)jsonBody);
        return new ResponseEncryptItem(responseBody, realBody);
    }

    @Override
    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    @Override
    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public void setFopOauthEncrypt(FopOauthEncrypt fopOauthEncrypt) {
        this.fopOauthEncrypt = fopOauthEncrypt;
    }

    public void setProdCode(String prodCode) {
        this.prodCode = prodCode;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setSignType(SignType signType) {
        this.signType = signType;
    }

    public void setEncryptType(EncryptType encryptType) {
        this.encryptType = encryptType;
    }

    @Override
    public void setEncryptKey(String encryptKey) {
        this.encryptKey = encryptKey;
    }

    public void setFopPublicKey(String FopPublicKey) {
        this.fopPublicKey = FopPublicKey;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    @Override
    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public FopHashMap paramEncrypt(FopRequest<?> request, FopHashMap appParams) throws FopApiException {
        String params = request.getEncryptParams();
        if (StringUtils.areNotEmpty(params) && null != this.encryptType) {
            String[] paramArry;
            String biz_content = (String)appParams.get("uop_data");
            JSONObject jsonMap = JSONObject.parseObject((String)biz_content);
            for (String param : paramArry = params.split(",")) {
                String val = jsonMap.getString(param);
                if (!StringUtils.areNotEmpty(val)) continue;
                String encryptContent = FopEncrypt.encryptContent(val, this.encryptType.getValue(), this.encryptKey, this.charset);
                jsonMap.put(param, (Object)encryptContent);
            }
            appParams.put("uop_data", JSONObject.toJSONString((Object)jsonMap));
        }
        return appParams;
    }

    public static PrivateKey getPrivateKeyFromPKCS8(String algorithm, InputStream ins) throws Exception {
        if (ins == null || StringUtils.isEmpty(algorithm)) {
            return null;
        }
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        byte[] encodedKey = StreamUtil.readText(ins).getBytes();
        encodedKey = Base64.getDecoder().decode(encodedKey);
        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
    }

    public static String getFopPublicKey(String alipayPublicCertPath) throws FopApiException {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(alipayPublicCertPath);
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(inputStream);
            PublicKey publicKey = cert.getPublicKey();
            String string = Base64.getEncoder().encodeToString(publicKey.getEncoded());
            return string;
        }
        catch (NoSuchProviderException e) {
            throw new FopApiException(e);
        }
        catch (IOException e) {
            throw new FopApiException(e);
        }
        catch (CertificateException e) {
            throw new FopApiException(e);
        }
        finally {
            try {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (IOException e) {
                throw new FopApiException(e);
            }
        }
    }

    static {
        Security.setProperty("jdk.certpath.disabledAlgorithms", "");
    }

    public static class Builder {
        private DefaultFopClient client;

        Builder(String appId, String privateKey, String fopPublicKey) {
            this.client = new DefaultFopClient(appId, privateKey, fopPublicKey);
        }

        public DefaultFopClient build() {
            return this.client;
        }

        public Builder SererUrl(String serverUrl) {
            this.client.setServerUrl(serverUrl);
            return this;
        }

        public Builder prodCode(String prodCode) {
            this.client.setProdCode(prodCode);
            return this;
        }

        public Builder format(String format) {
            this.client.setFormat(format);
            return this;
        }

        public Builder signType(SignType signType) {
            this.client.setSignType(signType);
            return this;
        }

        public Builder isBodyEncrypt(boolean isBodyEncrypt) {
            this.client.isBodyEncrypt = isBodyEncrypt;
            return this;
        }

        public Builder encryptType(EncryptType encryptType) {
            this.client.setEncryptType(encryptType);
            return this;
        }

        public Builder encryptKey(String encryptKey) {
            this.client.setEncryptKey(encryptKey);
            return this;
        }

        public Builder FopPublicKey(String fopPublicKey) {
            this.client.setFopPublicKey(fopPublicKey);
            return this;
        }

        public Builder charset(String charset) {
            this.client.setCharset(charset);
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.client.setConnectTimeout(connectTimeout);
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.client.setReadTimeout(readTimeout);
            return this;
        }

        public Builder proxyHost(String proxyHost) {
            this.client.setProxyHost(proxyHost);
            return this;
        }

        public Builder proxyPort(int proxyPort) {
            this.client.setProxyPort(proxyPort);
            return this;
        }
    }
}

