/*
 * Decompiled with CFR 0.152.
 */
package com.uop.sdk.internal.mapping;

import com.uop.sdk.FopApiException;
import com.uop.sdk.FopResponse;
import com.uop.sdk.internal.mapping.ApiField;
import com.uop.sdk.internal.mapping.ApiListField;
import com.uop.sdk.internal.mapping.FopFieldMethod;
import com.uop.sdk.internal.mapping.Reader;
import com.uop.sdk.internal.util.StringUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;

public class Converters {
    public static boolean isCheckJsonType = false;
    private static final Set<String> baseFields = new HashSet<String>();
    private static final Set<String> excludeFields = new HashSet<String>();
    private static final Set<String> overideFields = new HashSet<String>();

    private Converters() {
    }

    public static <T> T convert(Class<T> clazz, Reader reader) throws FopApiException {
        T rsp = null;
        try {
            rsp = clazz.newInstance();
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
            boolean isResponseClazz = FopResponse.class.isAssignableFrom(clazz);
            for (PropertyDescriptor pd : pds) {
                FopFieldMethod FopFieldMethod22;
                Field field;
                Method writeMethod = pd.getWriteMethod();
                if (writeMethod == null) continue;
                String itemName = pd.getName();
                String listName = null;
                if (isResponseClazz && excludeFields.contains(itemName)) continue;
                ArrayList<FopFieldMethod> FopFieldMethods = new ArrayList<FopFieldMethod>();
                if (baseFields.contains(itemName) && isResponseClazz) {
                    field = FopResponse.class.getDeclaredField(itemName);
                    FopFieldMethod22 = new FopFieldMethod();
                    FopFieldMethod22.setField(field);
                    if (writeMethod.getDeclaringClass().getName().contains("FopResponse")) {
                        FopFieldMethod22.setMethod(writeMethod);
                    } else {
                        if ((writeMethod = Converters.tryGetSetMethod(FopResponse.class, field, writeMethod.getName())) == null) continue;
                        FopFieldMethod22.setMethod(writeMethod);
                    }
                    FopFieldMethods.add(FopFieldMethod22);
                    if (overideFields.contains(itemName) && (field = Converters.tryGetFieldWithoutExp(clazz, itemName)) != null) {
                        if ((writeMethod = Converters.tryGetSetMethod(clazz, field, writeMethod.getName())) == null) continue;
                        FopFieldMethod22 = new FopFieldMethod();
                        FopFieldMethod22.setField(field);
                        FopFieldMethod22.setMethod(writeMethod);
                        FopFieldMethods.add(FopFieldMethod22);
                    }
                } else {
                    field = clazz.getDeclaredField(itemName);
                    FopFieldMethod22 = new FopFieldMethod();
                    FopFieldMethod22.setField(field);
                    FopFieldMethod22.setMethod(writeMethod);
                    FopFieldMethods.add(FopFieldMethod22);
                }
                for (FopFieldMethod FopFieldMethod22 : FopFieldMethods) {
                    Object value;
                    ApiListField jsonListField;
                    Field field2 = FopFieldMethod22.getField();
                    Method method = FopFieldMethod22.getMethod();
                    ApiField jsonField = field2.getAnnotation(ApiField.class);
                    if (jsonField != null) {
                        itemName = jsonField.value();
                    }
                    if ((jsonListField = field2.getAnnotation(ApiListField.class)) != null) {
                        listName = jsonListField.value();
                    }
                    if (!reader.hasReturnField(itemName) && (listName == null || !reader.hasReturnField(listName))) continue;
                    Class<?> typeClass = field2.getType();
                    if (String.class.isAssignableFrom(typeClass)) {
                        value = reader.getPrimitiveObject(itemName);
                        if (value instanceof String) {
                            method.invoke(rsp, value.toString());
                            continue;
                        }
                        if (isCheckJsonType && value != null) {
                            throw new FopApiException(itemName + " is not a String");
                        }
                        if (value != null) {
                            method.invoke(rsp, value.toString());
                            continue;
                        }
                        method.invoke(rsp, "");
                        continue;
                    }
                    if (Long.class.isAssignableFrom(typeClass)) {
                        value = reader.getPrimitiveObject(itemName);
                        if (value instanceof Long) {
                            method.invoke(rsp, (Long)value);
                            continue;
                        }
                        if (isCheckJsonType && value != null) {
                            throw new FopApiException(itemName + " is not a Number(Long)");
                        }
                        if (!StringUtils.isNumeric(value)) continue;
                        method.invoke(rsp, Long.valueOf(value.toString()));
                        continue;
                    }
                    if (Integer.class.isAssignableFrom(typeClass)) {
                        value = reader.getPrimitiveObject(itemName);
                        if (value instanceof Integer) {
                            method.invoke(rsp, (Integer)value);
                            continue;
                        }
                        if (isCheckJsonType && value != null) {
                            throw new FopApiException(itemName + " is not a Number(Integer)");
                        }
                        if (!StringUtils.isNumeric(value)) continue;
                        method.invoke(rsp, Integer.valueOf(value.toString()));
                        continue;
                    }
                    if (Boolean.class.isAssignableFrom(typeClass)) {
                        value = reader.getPrimitiveObject(itemName);
                        if (value instanceof Boolean) {
                            method.invoke(rsp, (Boolean)value);
                            continue;
                        }
                        if (isCheckJsonType && value != null) {
                            throw new FopApiException(itemName + " is not a Boolean");
                        }
                        if (value == null) continue;
                        method.invoke(rsp, Boolean.valueOf(value.toString()));
                        continue;
                    }
                    if (Double.class.isAssignableFrom(typeClass)) {
                        value = reader.getPrimitiveObject(itemName);
                        if (value instanceof Double) {
                            method.invoke(rsp, (Double)value);
                            continue;
                        }
                        if (!isCheckJsonType || value == null) continue;
                        throw new FopApiException(itemName + " is not a Double");
                    }
                    if (Number.class.isAssignableFrom(typeClass)) {
                        value = reader.getPrimitiveObject(itemName);
                        if (value instanceof Number) {
                            method.invoke(rsp, (Number)value);
                            continue;
                        }
                        if (!isCheckJsonType || value == null) continue;
                        throw new FopApiException(itemName + " is not a Number");
                    }
                    if (Date.class.isAssignableFrom(typeClass)) {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        format.setTimeZone(TimeZone.getTimeZone("GMT+8"));
                        Object value2 = reader.getPrimitiveObject(itemName);
                        if (!(value2 instanceof String)) continue;
                        method.invoke(rsp, format.parse(value2.toString()));
                        continue;
                    }
                    if (List.class.isAssignableFrom(typeClass)) {
                        Class subType;
                        List<?> listObjs;
                        ParameterizedType paramType;
                        Type[] genericTypes;
                        Type fieldType = field2.getGenericType();
                        if (!(fieldType instanceof ParameterizedType) || (genericTypes = (paramType = (ParameterizedType)fieldType).getActualTypeArguments()) == null || genericTypes.length <= 0 || !(genericTypes[0] instanceof Class) || (listObjs = reader.getListObjects(listName, itemName, subType = (Class)genericTypes[0])) == null) continue;
                        method.invoke(rsp, listObjs);
                        continue;
                    }
                    Object obj = reader.getObject(itemName, typeClass);
                    if (obj == null) continue;
                    method.invoke(rsp, obj);
                }
            }
        }
        catch (Exception e) {
            throw new FopApiException(e);
        }
        return rsp;
    }

    private static Field tryGetFieldWithoutExp(Class<?> clazz, String itemName) {
        try {
            return clazz.getDeclaredField(itemName);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static <T> Method tryGetSetMethod(Class<T> clazz, Field field, String methodName) {
        try {
            return clazz.getDeclaredMethod(methodName, field.getType());
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        baseFields.add("code");
        baseFields.add("msg");
        baseFields.add("bizCode");
        baseFields.add("bizMsg");
        baseFields.add("body");
        baseFields.add("params");
        baseFields.add("success");
        excludeFields.add("errorCode");
        overideFields.add("code");
        overideFields.add("msg");
    }
}

