/*
 * Decompiled with CFR 0.152.
 */
package com.uop.sdk.internal.parser.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.uop.sdk.FopApiException;
import com.uop.sdk.FopRequest;
import com.uop.sdk.FopResponse;
import com.uop.sdk.ResponseParseItem;
import com.uop.sdk.SignItem;
import com.uop.sdk.internal.mapping.Converter;
import com.uop.sdk.internal.mapping.Converters;
import com.uop.sdk.internal.mapping.Reader;
import com.uop.sdk.internal.util.FopEncrypt;
import com.uop.sdk.internal.util.FopSignature;
import com.uop.sdk.internal.util.MapToBeanUtils;
import com.uop.sdk.internal.util.StringUtils;
import com.uop.sdk.internal.util.json.ExceptionErrorListener;
import com.uop.sdk.internal.util.json.JSONReader;
import com.uop.sdk.internal.util.json.JSONValidatingReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class FopJsonConverter
implements Converter {
    @Override
    public <T extends FopResponse> T toResponse(String rsp, Class<T> clazz) {
        JSONValidatingReader reader = new JSONValidatingReader(new ExceptionErrorListener());
        Object rootObj = ((JSONReader)reader).read(rsp);
        if (rootObj instanceof Map) {
            Map rootJson = (Map)rootObj;
            Map jsonMap = null;
            if (rootJson.containsKey("uop_data") && null != rootJson.get("uop_data")) {
                jsonMap = (Map)rootJson.get("uop_data");
            }
            try {
                if (jsonMap == null) {
                    jsonMap = (Map)rootObj;
                }
                return (T)((FopResponse)MapToBeanUtils.convertMap2Bean(jsonMap, clazz));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    @Override
    public <T extends FopResponse> T toResponse(String rsp, Class<T> clazz, String uop) {
        return (T)((FopResponse)JSON.parseObject((String)rsp, clazz));
    }

    public <T> T fromJson(final Map<?, ?> json, Class<T> clazz) throws FopApiException {
        return Converters.convert(clazz, new Reader(){

            @Override
            public boolean hasReturnField(Object name) {
                return json.containsKey(name);
            }

            @Override
            public Object getPrimitiveObject(Object name) {
                return json.get(name);
            }

            @Override
            public Object getObject(Object name, Class<?> type) throws FopApiException {
                Object tmp = json.get(name);
                if (tmp instanceof Map) {
                    Map map = (Map)tmp;
                    return FopJsonConverter.this.fromJson(map, type);
                }
                return null;
            }

            @Override
            public List<?> getListObjects(Object listName, Object itemName, Class<?> subType) throws FopApiException {
                List<Object> listObjs = null;
                Object listTmp = json.get(listName);
                if (listTmp instanceof Map) {
                    Map jsonMap = (Map)listTmp;
                    Object itemTmp = jsonMap.get(itemName);
                    if (itemTmp == null && listName != null) {
                        String listNameStr = listName.toString();
                        itemTmp = jsonMap.get(listNameStr.substring(0, listNameStr.length() - 1));
                    }
                    if (itemTmp instanceof List) {
                        listObjs = this.getListObjectsInner(subType, itemTmp);
                    }
                } else if (listTmp instanceof List) {
                    listObjs = this.getListObjectsInner(subType, listTmp);
                }
                return listObjs;
            }

            private List<Object> getListObjectsInner(Class<?> subType, Object itemTmp) throws FopApiException {
                ArrayList<Object> listObjs = new ArrayList<Object>();
                List tmpList = (List)itemTmp;
                for (Object subTmp : tmpList) {
                    Date obj = null;
                    if (String.class.isAssignableFrom(subType)) {
                        obj = (Date)subTmp;
                    } else if (Long.class.isAssignableFrom(subType)) {
                        obj = (Date)subTmp;
                    } else if (Integer.class.isAssignableFrom(subType)) {
                        obj = (Date)subTmp;
                    } else if (Boolean.class.isAssignableFrom(subType)) {
                        obj = (Date)subTmp;
                    } else if (Date.class.isAssignableFrom(subType)) {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        try {
                            obj = format.parse(String.valueOf(subTmp));
                        }
                        catch (ParseException e) {
                            throw new FopApiException(e);
                        }
                    } else if (subTmp instanceof Map) {
                        Map subMap = (Map)subTmp;
                        obj = FopJsonConverter.this.fromJson(subMap, subType);
                    }
                    if (obj == null) continue;
                    listObjs.add(obj);
                }
                return listObjs;
            }
        });
    }

    @Override
    public SignItem getSignItem(FopRequest<?> request, String responseBody) {
        if (StringUtils.isEmpty(responseBody)) {
            return null;
        }
        SignItem signItem = new SignItem();
        String sign = this.getSign(responseBody);
        signItem.setSign(sign);
        String signSourceData = this.getSignSourceData(responseBody);
        signItem.setSignSourceDate(signSourceData);
        return signItem;
    }

    private String getSignSourceData(String body) {
        JSONObject jsonBody = JSONObject.parseObject((String)body);
        jsonBody.remove((Object)"uop_sign");
        jsonBody.remove((Object)"uop_code");
        jsonBody.remove((Object)"uop_msg");
        String signContent = FopSignature.getSignContent(FopSignature.getSortedMap(jsonBody));
        return signContent;
    }

    private String parseSignSourceData(String body, String rootNode, int indexOfRootNode) {
        int signDataStartIndex = indexOfRootNode + rootNode.length() + 2;
        int indexOfSign = body.indexOf("\"X-Uop-Signature\"");
        if (indexOfSign < 0) {
            return null;
        }
        int signDataEndIndex = indexOfSign - 1;
        return body.substring(signDataStartIndex, signDataEndIndex);
    }

    private String getSign(String body) {
        JSONValidatingReader reader = new JSONValidatingReader(new ExceptionErrorListener());
        Object rootObj = ((JSONReader)reader).read(body);
        Map rootJson = (Map)rootObj;
        return (String)rootJson.get("uop_sign");
    }

    @Override
    public String encryptSourceData(FopRequest<?> request, String body, String format, String encryptType, String encryptKey, String charset) throws FopApiException {
        ResponseParseItem respSignSourceData = this.getJSONSignSourceData(request, body);
        String bodyIndexContent = body.substring(0, respSignSourceData.getStartIndex());
        String bodyEndContent = body.substring(respSignSourceData.getEndIndex());
        return bodyIndexContent + FopEncrypt.decryptContent(respSignSourceData.getEncryptContent(), encryptType, encryptKey, charset) + bodyEndContent;
    }

    private ResponseParseItem getJSONSignSourceData(FopRequest<?> request, String body) {
        String rootNode = request.getApiMethodName().replace('.', '_') + "_response";
        String errorRootNode = "error_response";
        int indexOfRootNode = body.indexOf(rootNode);
        int indexOfErrorRoot = body.indexOf(errorRootNode);
        if (indexOfRootNode > 0) {
            return this.parseJSONSignSourceData(body, rootNode, indexOfRootNode);
        }
        if (indexOfErrorRoot > 0) {
            return this.parseJSONSignSourceData(body, errorRootNode, indexOfErrorRoot);
        }
        return null;
    }

    private ResponseParseItem parseJSONSignSourceData(String body, String rootNode, int indexOfRootNode) {
        int signDataStartIndex = indexOfRootNode + rootNode.length() + 2;
        int indexOfSign = body.indexOf("\"X-Uop-Signature\"");
        if (indexOfSign < 0) {
            indexOfSign = body.length();
        }
        int signDataEndIndex = indexOfSign - 1;
        String encryptContent = body.substring(signDataStartIndex + 1, signDataEndIndex - 1);
        return new ResponseParseItem(signDataStartIndex, signDataEndIndex, encryptContent);
    }
}

