/*
 * Decompiled with CFR 0.152.
 */
package com.uop.sdk.internal.util;

import com.uop.sdk.FopApiException;
import com.uop.sdk.internal.util.Base64;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESUtil {
    private static final String AES_ALG = "AES";
    private static final String AES_CBC_PCK_ALG = "AES/CBC/PKCS5Padding";
    private static final byte[] AES_IV = AESUtil.initIv("AES/CBC/PKCS5Padding");
    private static final String CHARSET_UTF8 = "UTF-8";
    private static int keySize = 128;
    private static IvParameterSpec iv = new IvParameterSpec(AES_IV);

    public static String aesEncrypt(String content, String aesKey) throws FopApiException {
        return AESUtil.aesEncrypt(content, aesKey, CHARSET_UTF8);
    }

    public static String aesEncrypt(String content, String aesKey, String charset) throws FopApiException {
        try {
            return new String(AESUtil.aesEncrypt(content.getBytes(charset), aesKey));
        }
        catch (Exception e) {
            throw new FopApiException("AES\u52a0\u5bc6\u5931\u8d25\uff1aAescontent = " + content + "; charset = " + charset);
        }
    }

    public static byte[] aesEncrypt(byte[] content, String aesKey) throws FopApiException {
        try {
            Cipher cipher = Cipher.getInstance(AES_CBC_PCK_ALG);
            cipher.init(1, (Key)new SecretKeySpec(Base64.getDecoder().decode(aesKey), AES_ALG), iv);
            byte[] encryptBytes = cipher.doFinal(content);
            return Base64.getEncoder().encode(encryptBytes);
        }
        catch (Exception e) {
            throw new FopApiException("AES\u52a0\u5bc6\u5931\u8d25\uff1aAescontent = " + content);
        }
    }

    public static String aesDecrypt(String content, String aesKey) throws FopApiException {
        return AESUtil.aesDecrypt(content, aesKey, CHARSET_UTF8);
    }

    public static byte[] aesDecrypt(byte[] content, String aesKey) throws FopApiException {
        try {
            Cipher cipher = Cipher.getInstance(AES_CBC_PCK_ALG);
            cipher.init(2, (Key)new SecretKeySpec(Base64.getDecoder().decode(aesKey.getBytes()), AES_ALG), iv);
            return cipher.doFinal(Base64.getDecoder().decode(content));
        }
        catch (Exception e) {
            throw new FopApiException("AES\u89e3\u5bc6\u5931\u8d25\uff1aAescontent = " + content);
        }
    }

    public static String aesDecrypt(String content, String aesKey, String charset) throws FopApiException {
        try {
            Cipher cipher = Cipher.getInstance(AES_CBC_PCK_ALG);
            cipher.init(2, (Key)new SecretKeySpec(Base64.getDecoder().decode(aesKey.getBytes()), AES_ALG), iv);
            byte[] cleanBytes = cipher.doFinal(Base64.getDecoder().decode(content.getBytes()));
            return new String(cleanBytes, charset);
        }
        catch (Exception e) {
            throw new FopApiException("AES\u89e3\u5bc6\u5931\u8d25\uff1aAescontent = " + content);
        }
    }

    private static byte[] initIv(String fullAlg) {
        try {
            Cipher cipher = Cipher.getInstance(fullAlg);
            int blockSize = cipher.getBlockSize();
            byte[] iv = new byte[blockSize];
            for (int i = 0; i < blockSize; ++i) {
                iv[i] = 0;
            }
            return iv;
        }
        catch (Exception e) {
            int blockSize = 16;
            byte[] iv = new byte[blockSize];
            for (int i = 0; i < blockSize; ++i) {
                iv[i] = 0;
            }
            return iv;
        }
    }

    public static String generateAesKey() {
        String key = "";
        try {
            KeyGenerator kgen = KeyGenerator.getInstance(AES_ALG);
            kgen.init(keySize);
            byte[] encoded = kgen.generateKey().getEncoded();
            key = Base64.getEncoder().encodeToString(encoded);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return key;
    }

    public static void main(String[] args) {
        for (int i = 1; i < 2; ++i) {
            long a = System.currentTimeMillis();
            String key = AESUtil.generateAesKey();
            System.out.println(key);
            System.out.println(System.currentTimeMillis() - a);
        }
    }
}

