/*
 * Decompiled with CFR 0.152.
 */
package com.uop.sdk.internal.util;

import com.uop.sdk.FopApiException;
import com.uop.sdk.internal.util.Base64;
import com.uop.sdk.internal.util.StringUtils;
import com.uop.sdk.internal.util.codec.SM4;
import com.uop.sdk.internal.util.codec.SM4_Context;
import com.uop.sdk.internal.util.codec.Util;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.KeyGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SM4Utils {
    private static String iv = "UISwD9fW6cFh9SNS";
    private static boolean hexString = false;
    private static int keySize = 128;
    private static KeyGenerator kg;

    public static String encryptData_ECB(String plainText, String secretKey) throws FopApiException {
        try {
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            byte[] keyBytes = secretKey.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_ecb(ctx, plainText.getBytes("UTF-8"));
            String cipherText = Base64.getEncoder().encodeToString(encrypted);
            if (cipherText != null && cipherText.trim().length() > 0) {
                Pattern p = Pattern.compile("\\s*|\t|\r|\n");
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            return cipherText;
        }
        catch (Exception e) {
            throw new FopApiException("SM4\u52a0\u5bc6\u5931\u8d25\uff1acontent: " + plainText, e);
        }
    }

    public static String decryptData_ECB(String cipherText, String secretKey) throws FopApiException {
        try {
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            byte[] keyBytes = secretKey.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            Base64.getDecoder().decode(cipherText.getBytes());
            byte[] decrypted = sm4.sm4_crypt_ecb(ctx, Base64.getDecoder().decode(cipherText.getBytes()));
            return new String(decrypted, "UTF-8");
        }
        catch (Exception e) {
            throw new FopApiException("SM4\u89e3\u5bc6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u89e3\u5bc6\u79d8\u94a5\u6216\u89e3\u5bc6\u7c7b\u578b,\u89e3\u5bc6\u5b57\u6bb5\u662f\u5426\u914d\u7f6e\u6b63\u786e\uff1acipherText: " + cipherText, e);
        }
    }

    public static String encryptData_CBC(String plainText, String secretKey) {
        return Base64.getEncoder().encodeToString(SM4Utils.encryptData_CBC(plainText.getBytes(), secretKey));
    }

    public static byte[] encryptData_CBC(byte[] content, String secretKey) {
        try {
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            byte[] keyBytes = secretKey.getBytes();
            byte[] ivBytes = iv.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, content);
            String cipherText = Base64.getEncoder().encodeToString(encrypted);
            if (cipherText != null && cipherText.trim().length() > 0) {
                Pattern p = Pattern.compile("\\s*|\t|\r|\n");
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            return Base64.getDecoder().decode(cipherText);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String decryptData_CBC(String cipherText, String secretKey) {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            if (hexString) {
                keyBytes = Util.hexStringToBytes(secretKey);
                ivBytes = Util.hexStringToBytes(iv);
            } else {
                keyBytes = secretKey.getBytes();
                ivBytes = iv.getBytes();
            }
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, Base64.getDecoder().decode(cipherText.getBytes()));
            return new String(decrypted, "UTF-8");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean verifyEcb(String plainText, String cipherText, String secretKey) {
        boolean flag = false;
        try {
            if (StringUtils.isEmpty(secretKey) || StringUtils.isEmpty(plainText) || StringUtils.isEmpty(cipherText)) {
                return flag;
            }
            String encryptData_ECB = SM4Utils.encryptData_ECB(secretKey, plainText);
            flag = cipherText.equals(encryptData_ECB);
            return flag;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String generateSm4Key() throws FopApiException {
        String key = Base64.getEncoder().encodeToString(kg.generateKey().getEncoded());
        return key;
    }

    static {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            kg = KeyGenerator.getInstance("SM4", "BC");
            kg.init(keySize, new SecureRandom());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

