package cn.com.wawa.service.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Desc:
 * @Author: xuwei
 * @Date: 2018/7/9 19:08
 */
@Data
public class BannerCardDto implements Serializable {
    /**
     * 主键id
     */
    private Long id;

    /**
     * 卡片名称
     */
    private String cardName;

    /**
     * 卡片类型 1：功能型 2：运营型
     */
    private Integer cardType;

    /**
     * 卡片代码 0：默认 1：排行榜 2：周卡/月卡 3：上新
     */
    private Integer cardCode;

    /**
     * 跳转链接
     */
    private String url;

    /**
     * 背景图片地址
     */
    private String image;

    /**
     * 文案描述
     */
    private String copywriting;

    /**
     * 扩展信息
     */
    private String extra;

    /**
     * 状态 1：上线 2：下线
     */
    private Integer cardStatus;

    /**
     * 用户类型 0:全部 1:未抓中过 2:抓中过
     */
    private Integer userType;

    /**
     * 排序
     */
    private Integer payload;

    /**
     * 充值后状态 1：上线 2：下线
     */
    private Integer chargeState;

    /**
     * 充值金额
     */
    private Long chargeMoney;

    /**
     * 定向Id
     */
    private Long redirectId;

    /**
     * 最小版本
     */
    private Integer minVersionCode;

    /**
     * 最大版本
     */
    private Integer maxVersionCode;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 平台 0：全部 1：IOS 2：ANDROID
     */
    private Integer clientType;

    /**
     * 上线时间
     */
    private Date openTime;

    /**
     * 下线时间
     */
    private Date closeTime;
}
