package cn.com.wawa.service.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class ReturnAwardRateControlConfigDto implements Serializable {
    private static final long serialVersionUID = -4357612780237241550L;

    private Long id;

    private Long buzId;

    private Integer controlDimension;

    /**
     * 调控配置参数字符串,格式为"X(1):Y(1);X(2):Y(2);X(3):Y(3)",X(N)为调控返奖率的分段零界点，X(N)呈递增趋势
     * Y(N)为 X(N) <= ReturnAwardRate < X(N+1) 时的调控系数，为便于计算X(N)和Y(N)都为实际比率*10000后的数值
     */
    private String controlConfig;

    private Integer usable;
    /**
     * 应用参数创建时间
     */
    private Date gmtCreate;

    /**
     * 应用参数修改时间
     */
    private Date gmtModified;

}
