package cn.com.wawa.service.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
@ApiModel(value = "版本信息")
public class VersionDto implements Serializable {
    private static final long serialVersionUID = -5535822086764301408L;

    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date gmtCreate;

    @ApiModelProperty(value = "是否静默安装")
    private boolean isSilent;
    @ApiModelProperty(value = "是否强制更新")
    private boolean isForce;
    @ApiModelProperty(value = "是否下载完成后自动安装")
    private boolean isAutoInstall;
    @ApiModelProperty(value = "是否可忽略该版本")
    private boolean isIgnorable;
    @ApiModelProperty(value = "版本号")
    private String versionCode;
    @ApiModelProperty(value = "版本名")
    private String versionName;
    @ApiModelProperty(value = "apk文件下载url")
    private String url;
    @ApiModelProperty(value = "文件的md5值")
    private String md5;
    @ApiModelProperty(value = "包大小")
    private Long size;
    @ApiModelProperty(value = "更新内容")
    private String updateContent;
    @ApiModelProperty(value = "上下线状态  0-下线 1-上线")
    private Integer status;
    @ApiModelProperty(value = "客户端类型0:安卓 1：ios")
    private Integer clientType;
    @ApiModelProperty(value = "弹窗地址")
    private String picUrl;

}
