package cn.com.wawa.service.api.enums;

/**
 * 用户账户变动明细类型
 * code标示增减类型0-增加 1-减少
 */
public enum AccountChangeTypeEnum {

    CHARGE(1, "充值",0),
    FIRST_CHARGE(2, "首冲奖励",0),
    CATCH_WAWA(3, "抽娃娃消费",1),
    POSTAGE(4, "邮费",1),
    NEW_USER_GIFT(5,"新人奖励",0),
    NEW_USER_INVITED(6,"新人被邀请奖励",0),
    INVITE_BONUS(7,"邀请奖励",0),
    ACTIVITY_RECEIVE(8, "活动赠送",0),
    CREDITS_CONSUME(9,"积分商城消费",1),
    ROLL_BACK(10, "回滚操作",1),
    RED_PACKAGE_RECEIVE(11, "红包赠送",0),
    STRONG_GRAB_NO_CATCHED(12, "强抓不中送币",0),
    APPEAL_RETURN_COIN(13, "申诉后退币",0),
    CREDITS_EXCHANGE(14,"积分兑换",0),
    BUY_CARD(15, "买卡送币", 0),
    RANK_AWARD(16, "排行榜奖品", 0),
    CONVERSION_WAWA(17,"娃娃兑换",0),
    LIMIT_CATCH_WAWA(18,"限时抓娃娃单人场消费",1),
    ACTIVITY_TASK_AWARD(19, "豪礼活动任务奖励", 0),
    LIMIT_CATCH_1V1(20, "限时抓娃娃1v1匹配场消费", 1),
    ADD_COIN(21, "加币", 0),
    PK_WIN_ADD_COIN(22,"限时抓娃娃1v1匹配场加币",0),
    VIP_GIFT_COIN(23,"vip礼包赠币",0),
    FLIP_REWARD_COIN(24,"翻牌有奖",0),
    DELIVERY_COMPENSATE(25,"收货补偿加币",0),
    SYSTEM_ERROR_COMPENSATE(26,"系统异常加币",0),
    TIME_LIMIT_APPEAL_COMPENSATE(27,"限时玩法加币",0),
    LOGISTICS_ERROR_COMPENSATE(28,"物流异常加币",0),
    SPECIAL_REASONS_COMPENSATE(29,"特殊原因补偿加币",0),
    USER_SURVEY_ADD_COIN(30,"用户调研奖励加币",0),
    CARD_CHARGE(31, "卡充值", 0),
    TUIA_GAME_REWARD(32, "游戏大厅奖励", 0),

    //分享帮抓相关
    SHARE_DAILY_REWARD(41,"分享奖励",0),
    SHARE_DOWNLOAD_REWARD(42,"邀请奖励",0),
    SHARED_DOWNLOAD_REWARD(43,"受邀奖励",0),
    SHARER_REWARD(44,"邀请奖励",0)


    ;

    private int    value;
    private String desc;
    private int code;

    AccountChangeTypeEnum(int value, String desc,int code) {
        this.value = value;
        this.desc = desc;
        this.code = code;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public int code (){
        return code;
    }

    public static AccountChangeTypeEnum get(int value) {
        for (AccountChangeTypeEnum item : AccountChangeTypeEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }
}
